/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.ArrayDoubleList;
import org.apache.commons.collections.primitives.DoubleIterator;
import org.apache.commons.collections.primitives.DoubleList;
import org.apache.commons.collections.primitives.DoubleListIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableDoubleIterator;
import org.apache.commons.collections.primitives.decorators.UnmodifiableDoubleList;
import org.apache.commons.collections.primitives.decorators.UnmodifiableDoubleListIterator;

public final class DoubleCollections {
    public static final DoubleList EMPTY_DOUBLE_LIST = DoubleCollections.unmodifiableDoubleList(new ArrayDoubleList(0));
    public static final DoubleIterator EMPTY_DOUBLE_ITERATOR = DoubleCollections.unmodifiableDoubleIterator(EMPTY_DOUBLE_LIST.iterator());
    public static final DoubleListIterator EMPTY_DOUBLE_LIST_ITERATOR = DoubleCollections.unmodifiableDoubleListIterator(EMPTY_DOUBLE_LIST.listIterator());

    private DoubleCollections() {
    }

    @Nonnull
    public static DoubleList singletonDoubleList(double d) {
        ArrayDoubleList arrayDoubleList = new ArrayDoubleList(1);
        arrayDoubleList.add(d);
        return UnmodifiableDoubleList.wrap(arrayDoubleList);
    }

    @Nonnull
    public static DoubleIterator singletonDoubleIterator(double d) {
        return DoubleCollections.singletonDoubleList(d).iterator();
    }

    @Nonnull
    public static DoubleListIterator singletonDoubleListIterator(double d) {
        return DoubleCollections.singletonDoubleList(d).listIterator();
    }

    @Nonnull
    public static DoubleList unmodifiableDoubleList(@Nonnull DoubleList doubleList) throws NullPointerException {
        if (null == doubleList) {
            throw new NullPointerException();
        }
        return UnmodifiableDoubleList.wrap(doubleList);
    }

    @Nonnull
    public static DoubleIterator unmodifiableDoubleIterator(@Nonnull DoubleIterator doubleIterator) {
        if (null == doubleIterator) {
            throw new NullPointerException();
        }
        return UnmodifiableDoubleIterator.wrap(doubleIterator);
    }

    @Nonnull
    public static DoubleListIterator unmodifiableDoubleListIterator(@Nonnull DoubleListIterator doubleListIterator) {
        if (null == doubleListIterator) {
            throw new NullPointerException();
        }
        return UnmodifiableDoubleListIterator.wrap(doubleListIterator);
    }

    @Nonnull
    public static DoubleList getEmptyDoubleList() {
        return EMPTY_DOUBLE_LIST;
    }

    @Nonnull
    public static DoubleIterator getEmptyDoubleIterator() {
        return EMPTY_DOUBLE_ITERATOR;
    }

    @Nonnull
    public static DoubleListIterator getEmptyDoubleListIterator() {
        return EMPTY_DOUBLE_LIST_ITERATOR;
    }
}

