/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.util.EmptyStackException;
import javax.annotation.Nonnegative;
import org.apache.commons.collections.primitives.ArrayFloatList;

public class FloatStack {
    private final ArrayFloatList m_aList = new ArrayFloatList();

    public FloatStack() {
    }

    public FloatStack(float[] fArray) {
        for (float f : fArray) {
            this.m_aList.add(f);
        }
    }

    @Deprecated
    public boolean empty() {
        return this.isEmpty();
    }

    public boolean isEmpty() {
        return this.m_aList.isEmpty();
    }

    public float peek() {
        if (this.m_aList.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.m_aList.get(this.m_aList.size() - 1);
    }

    public float peek(int n) {
        if (this.m_aList.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.m_aList.get(this.m_aList.size() - n - 1);
    }

    public float pop() {
        if (this.m_aList.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.m_aList.removeElementAt(this.m_aList.size() - 1);
    }

    public float push(float f) {
        this.m_aList.add(f);
        return f;
    }

    public int search(float f) {
        for (int i = this.m_aList.size() - 1; i >= 0; --i) {
            if (this.m_aList.get(i) != f) continue;
            return this.m_aList.size() - i;
        }
        return -1;
    }

    public float get(int n) {
        return this.m_aList.get(n);
    }

    @Nonnegative
    public int size() {
        return this.m_aList.size();
    }

    public void clear() {
        this.m_aList.clear();
    }
}

