/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import com.phloc.commons.hash.HashCodeGenerator;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.AbstractShortCollection;
import org.apache.commons.collections.primitives.ShortCollection;
import org.apache.commons.collections.primitives.ShortIterator;
import org.apache.commons.collections.primitives.ShortList;
import org.apache.commons.collections.primitives.ShortListIterator;

public abstract class RandomAccessShortList
extends AbstractShortCollection
implements ShortList {
    private int _modCount = 0;

    protected RandomAccessShortList() {
    }

    @Override
    public abstract short get(int var1);

    @Override
    public abstract int size();

    @Override
    public short removeElementAt(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short set(int n, short s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int n, short s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(short s) {
        this.add(this.size(), s);
        return true;
    }

    @Override
    public boolean addAll(int n, @Nonnull ShortCollection shortCollection) {
        int n2 = n;
        boolean bl = false;
        ShortIterator shortIterator = shortCollection.iterator();
        while (shortIterator.hasNext()) {
            this.add(n2++, shortIterator.next());
            bl = true;
        }
        return bl;
    }

    @Override
    public int indexOf(short s) {
        int n = 0;
        ShortIterator shortIterator = this.iterator();
        while (shortIterator.hasNext()) {
            if (shortIterator.next() == s) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(short s) {
        ShortListIterator shortListIterator = this.listIterator(this.size());
        while (shortListIterator.hasPrevious()) {
            if (shortListIterator.previous() != s) continue;
            return shortListIterator.nextIndex();
        }
        return -1;
    }

    @Override
    public ShortIterator iterator() {
        return this.listIterator();
    }

    @Override
    public ShortListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ShortListIterator listIterator(int n) {
        return new RandomAccessShortListIterator(this, n);
    }

    @Override
    public ShortList subList(int n, int n2) {
        return new RandomAccessShortSubList(this, n, n2);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ShortList)) {
            return false;
        }
        ShortList shortList = (ShortList)object;
        if (this.size() != shortList.size()) {
            return false;
        }
        ShortIterator shortIterator = shortList.iterator();
        ShortIterator shortIterator2 = this.iterator();
        while (shortIterator2.hasNext()) {
            if (shortIterator2.next() == shortIterator.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(this);
        ShortIterator shortIterator = this.iterator();
        while (shortIterator.hasNext()) {
            hashCodeGenerator.append(shortIterator.next());
        }
        return hashCodeGenerator.getHashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        ShortIterator shortIterator = this.iterator();
        while (shortIterator.hasNext()) {
            stringBuilder.append(shortIterator.next());
            if (!shortIterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    protected int getModCount() {
        return this._modCount;
    }

    protected void incrModCount() {
        ++this._modCount;
    }

    protected static class RandomAccessShortSubList
    extends RandomAccessShortList {
        private int _offset = 0;
        private int _limit = 0;
        private RandomAccessShortList _list = null;
        private ComodChecker _comod = null;

        RandomAccessShortSubList(RandomAccessShortList randomAccessShortList, int n, int n2) {
            if (n < 0 || n2 > randomAccessShortList.size()) {
                throw new IndexOutOfBoundsException();
            }
            if (n > n2) {
                throw new IllegalArgumentException();
            }
            this._list = randomAccessShortList;
            this._offset = n;
            this._limit = n2 - n;
            this._comod = new ComodChecker(randomAccessShortList);
            this._comod.resyncModCount();
        }

        @Override
        public short get(int n) {
            this.checkRange(n);
            this._comod.assertNotComodified();
            return this._list.get(this.toUnderlyingIndex(n));
        }

        @Override
        public short removeElementAt(int n) {
            this.checkRange(n);
            this._comod.assertNotComodified();
            short s = this._list.removeElementAt(this.toUnderlyingIndex(n));
            --this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
            return s;
        }

        @Override
        public short set(int n, short s) {
            this.checkRange(n);
            this._comod.assertNotComodified();
            short s2 = this._list.set(this.toUnderlyingIndex(n), s);
            this.incrModCount();
            this._comod.resyncModCount();
            return s2;
        }

        @Override
        public void add(int n, short s) {
            this.checkRangeIncludingEndpoint(n);
            this._comod.assertNotComodified();
            this._list.add(this.toUnderlyingIndex(n), s);
            ++this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
        }

        @Override
        public int size() {
            this._comod.assertNotComodified();
            return this._limit;
        }

        private void checkRange(int n) {
            if (n < 0 || n >= this.size()) {
                throw new IndexOutOfBoundsException("index " + n + " not in [0," + this.size() + ")");
            }
        }

        private void checkRangeIncludingEndpoint(int n) {
            if (n < 0 || n > this.size()) {
                throw new IndexOutOfBoundsException("index " + n + " not in [0," + this.size() + "]");
            }
        }

        private int toUnderlyingIndex(int n) {
            return n + this._offset;
        }
    }

    protected static class RandomAccessShortListIterator
    extends ComodChecker
    implements ShortListIterator {
        private int _nextIndex = 0;
        private int _lastReturnedIndex = -1;

        RandomAccessShortListIterator(RandomAccessShortList randomAccessShortList, int n) {
            super(randomAccessShortList);
            if (n < 0 || n > this.getList().size()) {
                throw new IndexOutOfBoundsException("Index " + n + " not in [0," + this.getList().size() + ")");
            }
            this._nextIndex = n;
            this.resyncModCount();
        }

        @Override
        public boolean hasNext() {
            this.assertNotComodified();
            return this._nextIndex < this.getList().size();
        }

        @Override
        public boolean hasPrevious() {
            this.assertNotComodified();
            return this._nextIndex > 0;
        }

        @Override
        public int nextIndex() {
            this.assertNotComodified();
            return this._nextIndex;
        }

        @Override
        public int previousIndex() {
            this.assertNotComodified();
            return this._nextIndex - 1;
        }

        @Override
        public short next() {
            this.assertNotComodified();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            short s = this.getList().get(this._nextIndex);
            this._lastReturnedIndex = this._nextIndex++;
            return s;
        }

        @Override
        public short previous() {
            this.assertNotComodified();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            short s = this.getList().get(this._nextIndex - 1);
            this._lastReturnedIndex = this._nextIndex - 1;
            --this._nextIndex;
            return s;
        }

        @Override
        public void add(short s) {
            this.assertNotComodified();
            this.getList().add(this._nextIndex, s);
            ++this._nextIndex;
            this._lastReturnedIndex = -1;
            this.resyncModCount();
        }

        @Override
        public void remove() {
            this.assertNotComodified();
            if (this._lastReturnedIndex == -1) {
                throw new IllegalStateException();
            }
            if (this._lastReturnedIndex == this._nextIndex) {
                this.getList().removeElementAt(this._lastReturnedIndex);
            } else {
                this.getList().removeElementAt(this._lastReturnedIndex);
                --this._nextIndex;
            }
            this._lastReturnedIndex = -1;
            this.resyncModCount();
        }

        @Override
        public void set(short s) {
            this.assertNotComodified();
            if (-1 == this._lastReturnedIndex) {
                throw new IllegalStateException();
            }
            this.getList().set(this._lastReturnedIndex, s);
            this.resyncModCount();
        }
    }

    private static class ComodChecker {
        private RandomAccessShortList _source = null;
        private int _expectedModCount = -1;

        ComodChecker(RandomAccessShortList randomAccessShortList) {
            this._source = randomAccessShortList;
            this.resyncModCount();
        }

        protected RandomAccessShortList getList() {
            return this._source;
        }

        protected void assertNotComodified() throws ConcurrentModificationException {
            if (this._expectedModCount != this.getList().getModCount()) {
                throw new ConcurrentModificationException();
            }
        }

        protected void resyncModCount() {
            this._expectedModCount = this.getList().getModCount();
        }
    }
}

