/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.ByteCollection;
import org.apache.commons.collections.primitives.adapters.ByteIteratorIterator;
import org.apache.commons.collections.primitives.adapters.CollectionByteCollection;

abstract class AbstractByteCollectionCollection
implements Collection<Byte> {
    AbstractByteCollectionCollection() {
    }

    @Nonnull
    protected abstract ByteCollection getByteCollection();

    @Override
    public boolean add(Byte by) {
        return this.getByteCollection().add(by);
    }

    @Override
    public boolean addAll(Collection<? extends Byte> collection) {
        return this.getByteCollection().addAll(CollectionByteCollection.wrap(collection));
    }

    @Override
    public void clear() {
        this.getByteCollection().clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.getByteCollection().contains((Byte)object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.getByteCollection().containsAll(CollectionByteCollection.wrap(collection));
    }

    public String toString() {
        return this.getByteCollection().toString();
    }

    @Override
    public boolean isEmpty() {
        return this.getByteCollection().isEmpty();
    }

    @Override
    public Iterator<Byte> iterator() {
        return ByteIteratorIterator.wrap(this.getByteCollection().iterator());
    }

    @Override
    public boolean remove(Object object) {
        return this.getByteCollection().removeElement((Byte)object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.getByteCollection().removeAll(CollectionByteCollection.wrap(collection));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.getByteCollection().retainAll(CollectionByteCollection.wrap(collection));
    }

    @Override
    public int size() {
        return this.getByteCollection().size();
    }

    @Nonnull
    @ReturnsMutableCopy
    public Byte[] toArray() {
        byte[] byArray = this.getByteCollection().toArray();
        Byte[] byteArray = new Byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byteArray[i] = byArray[i];
        }
        return byteArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        Byte[] byteArray = this.toArray();
        int n = this.size();
        if (TArray.length < n) {
            return Arrays.copyOf(byteArray, n, TArray.getClass());
        }
        System.arraycopy(byteArray, 0, TArray, 0, n);
        if (TArray.length > n) {
            TArray[n] = null;
        }
        return TArray;
    }
}

