/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.CharCollection;
import org.apache.commons.collections.primitives.adapters.CharIteratorIterator;
import org.apache.commons.collections.primitives.adapters.CollectionCharCollection;

abstract class AbstractCharCollectionCollection
implements Collection<Character> {
    AbstractCharCollectionCollection() {
    }

    @Nonnull
    protected abstract CharCollection getCharCollection();

    @Override
    public boolean add(Character c) {
        return this.getCharCollection().add(c.charValue());
    }

    @Override
    public boolean addAll(Collection<? extends Character> collection) {
        return this.getCharCollection().addAll(CollectionCharCollection.wrap(collection));
    }

    @Override
    public void clear() {
        this.getCharCollection().clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.getCharCollection().contains(((Character)object).charValue());
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.getCharCollection().containsAll(CollectionCharCollection.wrap(collection));
    }

    public String toString() {
        return this.getCharCollection().toString();
    }

    @Override
    public boolean isEmpty() {
        return this.getCharCollection().isEmpty();
    }

    @Override
    public Iterator<Character> iterator() {
        return CharIteratorIterator.wrap(this.getCharCollection().iterator());
    }

    @Override
    public boolean remove(Object object) {
        return this.getCharCollection().removeElement(((Character)object).charValue());
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.getCharCollection().removeAll(CollectionCharCollection.wrap(collection));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.getCharCollection().retainAll(CollectionCharCollection.wrap(collection));
    }

    @Override
    public int size() {
        return this.getCharCollection().size();
    }

    @Nonnull
    @ReturnsMutableCopy
    public Character[] toArray() {
        char[] cArray = this.getCharCollection().toArray();
        Character[] characterArray = new Character[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            characterArray[i] = Character.valueOf(cArray[i]);
        }
        return characterArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        Character[] characterArray = this.toArray();
        int n = this.size();
        if (TArray.length < n) {
            return Arrays.copyOf(characterArray, n, TArray.getClass());
        }
        System.arraycopy(characterArray, 0, TArray, 0, n);
        if (TArray.length > n) {
            TArray[n] = null;
        }
        return TArray;
    }
}

