/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import java.util.Collection;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.DoubleCollection;
import org.apache.commons.collections.primitives.DoubleIterator;
import org.apache.commons.collections.primitives.adapters.DoubleCollectionCollection;
import org.apache.commons.collections.primitives.adapters.IteratorDoubleIterator;

abstract class AbstractCollectionDoubleCollection
implements DoubleCollection {
    protected AbstractCollectionDoubleCollection() {
    }

    @Nonnull
    protected abstract Collection<Double> getCollection();

    @Override
    public boolean add(double d) {
        return this.getCollection().add(d);
    }

    @Override
    public boolean addAll(@Nonnull DoubleCollection doubleCollection) {
        return this.getCollection().addAll(DoubleCollectionCollection.wrap(doubleCollection));
    }

    @Override
    public void clear() {
        this.getCollection().clear();
    }

    @Override
    public boolean contains(double d) {
        return this.getCollection().contains(d);
    }

    @Override
    public boolean containsAll(@Nonnull DoubleCollection doubleCollection) {
        return this.getCollection().containsAll(DoubleCollectionCollection.wrap(doubleCollection));
    }

    @Override
    public boolean isEmpty() {
        return this.getCollection().isEmpty();
    }

    @Override
    @Nonnull
    public DoubleIterator iterator() {
        return IteratorDoubleIterator.wrap(this.getCollection().iterator());
    }

    @Override
    public boolean removeElement(double d) {
        return this.getCollection().remove(d);
    }

    @Override
    public boolean removeAll(@Nonnull DoubleCollection doubleCollection) {
        return this.getCollection().removeAll(DoubleCollectionCollection.wrap(doubleCollection));
    }

    @Override
    public boolean retainAll(@Nonnull DoubleCollection doubleCollection) {
        return this.getCollection().retainAll(DoubleCollectionCollection.wrap(doubleCollection));
    }

    @Override
    @Nonnegative
    public int size() {
        return this.getCollection().size();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public double[] toArray() {
        Object[] objectArray = this.getCollection().toArray();
        double[] dArray = new double[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            dArray[i] = (Double)objectArray[i];
        }
        return dArray;
    }

    @Override
    @Nonnull
    public double[] toArray(@Nonnull double[] dArray) {
        double[] dArray2 = dArray;
        Object[] objectArray = this.getCollection().toArray();
        if (dArray2.length < objectArray.length) {
            dArray2 = new double[objectArray.length];
        }
        for (int i = 0; i < objectArray.length; ++i) {
            dArray2[i] = (Double)objectArray[i];
        }
        return dArray2;
    }

    public String toString() {
        return this.getCollection().toString();
    }
}

