/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.FloatCollection;
import org.apache.commons.collections.primitives.adapters.CollectionFloatCollection;
import org.apache.commons.collections.primitives.adapters.FloatIteratorIterator;

abstract class AbstractFloatCollectionCollection
implements Collection<Float> {
    AbstractFloatCollectionCollection() {
    }

    @Nonnull
    protected abstract FloatCollection getFloatCollection();

    @Override
    public boolean add(Float f) {
        return this.getFloatCollection().add(f.floatValue());
    }

    @Override
    public boolean addAll(Collection<? extends Float> collection) {
        return this.getFloatCollection().addAll(CollectionFloatCollection.wrap(collection));
    }

    @Override
    public void clear() {
        this.getFloatCollection().clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.getFloatCollection().contains(((Float)object).floatValue());
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.getFloatCollection().containsAll(CollectionFloatCollection.wrap(collection));
    }

    public String toString() {
        return this.getFloatCollection().toString();
    }

    @Override
    public boolean isEmpty() {
        return this.getFloatCollection().isEmpty();
    }

    @Override
    public Iterator<Float> iterator() {
        return FloatIteratorIterator.wrap(this.getFloatCollection().iterator());
    }

    @Override
    public boolean remove(Object object) {
        return this.getFloatCollection().removeElement(((Float)object).floatValue());
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.getFloatCollection().removeAll(CollectionFloatCollection.wrap(collection));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.getFloatCollection().retainAll(CollectionFloatCollection.wrap(collection));
    }

    @Override
    public int size() {
        return this.getFloatCollection().size();
    }

    @Nonnull
    @ReturnsMutableCopy
    public Float[] toArray() {
        float[] fArray = this.getFloatCollection().toArray();
        Float[] floatArray = new Float[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            floatArray[i] = Float.valueOf(fArray[i]);
        }
        return floatArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        Float[] floatArray = this.toArray();
        int n = this.size();
        if (TArray.length < n) {
            return Arrays.copyOf(floatArray, n, TArray.getClass());
        }
        System.arraycopy(floatArray, 0, TArray, 0, n);
        if (TArray.length > n) {
            TArray[n] = null;
        }
        return TArray;
    }
}

