/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.FloatCollection;
import org.apache.commons.collections.primitives.FloatList;
import org.apache.commons.collections.primitives.adapters.AbstractFloatCollectionCollection;
import org.apache.commons.collections.primitives.adapters.CollectionFloatCollection;
import org.apache.commons.collections.primitives.adapters.FloatListIteratorListIterator;
import org.apache.commons.collections.primitives.adapters.FloatListList;

abstract class AbstractFloatListList
extends AbstractFloatCollectionCollection
implements List<Float> {
    AbstractFloatListList() {
    }

    @Nonnull
    protected abstract FloatList getFloatList();

    @Override
    @Nonnull
    protected final FloatCollection getFloatCollection() {
        return this.getFloatList();
    }

    @Override
    public void add(int n, @Nonnull Float f) {
        this.getFloatList().add(n, f.floatValue());
    }

    @Override
    public boolean addAll(int n, Collection<? extends Float> collection) {
        return this.getFloatList().addAll(n, CollectionFloatCollection.wrap(collection));
    }

    @Override
    @Nonnull
    public Float get(int n) {
        return Float.valueOf(this.getFloatList().get(n));
    }

    @Override
    public int indexOf(Object object) {
        return this.getFloatList().indexOf(((Float)object).floatValue());
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.getFloatList().lastIndexOf(((Float)object).floatValue());
    }

    @Override
    public ListIterator<Float> listIterator() {
        return FloatListIteratorListIterator.wrap(this.getFloatList().listIterator());
    }

    @Override
    public ListIterator<Float> listIterator(int n) {
        return FloatListIteratorListIterator.wrap(this.getFloatList().listIterator(n));
    }

    @Override
    @Nonnull
    public Float remove(int n) {
        return Float.valueOf(this.getFloatList().removeElementAt(n));
    }

    @Override
    @Nonnull
    public Float set(int n, Float f) {
        return Float.valueOf(this.getFloatList().set(n, f.floatValue()));
    }

    @Override
    public List<Float> subList(int n, int n2) {
        return FloatListList.wrap(this.getFloatList().subList(n, n2));
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.size() != list.size()) {
            return false;
        }
        Iterator<Float> iterator = this.iterator();
        Iterator iterator2 = list.iterator();
        while (iterator.hasNext()) {
            Float f = iterator.next();
            Object e = iterator2.next();
            if (!(null == f ? null != e : !((Object)f).equals(e))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return ((Object)this.getFloatList()).hashCode();
    }
}

