/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.decorators;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.IntList;
import org.apache.commons.collections.primitives.decorators.BaseUnmodifiableIntList;
import org.apache.commons.collections.primitives.decorators.NonSerializableUnmodifiableIntList;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public final class UnmodifiableIntList
extends BaseUnmodifiableIntList
implements Serializable {
    private transient IntList m_aProxied;

    UnmodifiableIntList(@Nonnull IntList intList) {
        this.m_aProxied = intList;
    }

    @Override
    @Nonnull
    protected IntList getProxiedList() {
        return this.m_aProxied;
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.m_aProxied);
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.m_aProxied = (IntList)objectInputStream.readObject();
    }

    @Nullable
    public static final IntList wrap(@Nullable IntList intList) {
        if (null == intList) {
            return null;
        }
        if (intList instanceof UnmodifiableIntList) {
            return intList;
        }
        if (intList instanceof Serializable) {
            return new UnmodifiableIntList(intList);
        }
        return new NonSerializableUnmodifiableIntList(intList);
    }
}

