/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.cache;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.cache.ConversionCacheEntry;
import org.nuxeo.ecm.core.convert.service.ConversionServiceImpl;

public class ConversionCacheHolder {
    protected static final Map<String, ConversionCacheEntry> cache = new HashMap<String, ConversionCacheEntry>();
    protected static final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private static final Log log = LogFactory.getLog(ConversionCacheHolder.class);
    public static int nbSubPathPart = 5;
    public static int subPathPartSize = 2;
    public static long cacheHits = 0L;

    private ConversionCacheHolder() {
    }

    public static long getCacheHits() {
        return cacheHits;
    }

    public static int getNbCacheEntries() {
        return cache.keySet().size();
    }

    protected static List<String> getSubPathFromKey(String key) {
        ArrayList<String> subPath = new ArrayList<String>();
        String path = Base64.encodeBase64String((byte[])key.getBytes());
        path = path.replace("+", "X");
        path = path.replace("/", "Y");
        int idx = 0;
        for (int i = 0; i < nbSubPathPart; ++i) {
            String subPart = path.substring(idx, idx + subPathPartSize);
            subPath.add(subPart);
            if ((idx += subPathPartSize) >= path.length()) break;
        }
        return subPath;
    }

    protected static String getCacheEntryPath(String key) {
        Path path = new Path(ConversionServiceImpl.getCacheBasePath());
        List<String> subPath = ConversionCacheHolder.getSubPathFromKey(key);
        for (String subPart : subPath) {
            path = path.append(subPart);
            new File(path.toString()).mkdir();
        }
        return path.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToCache(String key, BlobHolder result) {
        cacheLock.writeLock().lock();
        try {
            ConversionCacheHolder.doAddToCache(key, result);
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    protected static void doAddToCache(String key, BlobHolder result) {
        ConversionCacheEntry cce = new ConversionCacheEntry(result);
        boolean persisted = false;
        try {
            persisted = cce.persist(ConversionCacheHolder.getCacheEntryPath(key));
        }
        catch (Exception e) {
            log.error((Object)"Error while trying to persist cache entry", (Throwable)e);
        }
        if (persisted) {
            cache.put(key, cce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFromCache(String key) {
        cacheLock.writeLock().lock();
        try {
            ConversionCacheHolder.doRemoveFromCache(key);
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    protected static void doRemoveFromCache(String key) {
        if (cache.containsKey(key)) {
            ConversionCacheEntry cce = cache.get(key);
            cce.remove();
            cache.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConversionCacheEntry getCacheEntry(String key) {
        cacheLock.readLock().lock();
        try {
            ConversionCacheEntry conversionCacheEntry = ConversionCacheHolder.doGetCacheEntry(key);
            return conversionCacheEntry;
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    protected static ConversionCacheEntry doGetCacheEntry(String key) {
        return cache.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BlobHolder getFromCache(String key) {
        cacheLock.readLock().lock();
        try {
            BlobHolder blobHolder = ConversionCacheHolder.doGetFromCache(key);
            return blobHolder;
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    protected static BlobHolder doGetFromCache(String key) {
        ConversionCacheEntry cacheEntry = cache.get(key);
        if (cacheEntry != null) {
            cacheHits = cacheHits == Long.MAX_VALUE ? 0L : ++cacheHits;
            return cacheEntry.restore();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getCacheKeys() {
        cacheLock.readLock().lock();
        try {
            HashSet<String> hashSet = new HashSet<String>(cache.keySet());
            return hashSet;
        }
        finally {
            cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteCache() {
        cacheLock.writeLock().lock();
        try {
            cache.clear();
            new File(ConversionServiceImpl.getCacheBasePath()).delete();
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }
}

