/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model;

import java.io.Serializable;

public class ComponentName
implements Serializable {
    public static final String DEFAULT_TYPE = "service";
    private static final long serialVersionUID = -7686792831111487156L;
    private final String type;
    private final String name;
    private final String rawName;

    public ComponentName(String rawName) {
        int p = rawName.indexOf(58);
        if (p > -1) {
            this.type = rawName.substring(0, p).intern();
            this.name = rawName.substring(p + 1);
            this.rawName = rawName.intern();
        } else {
            this.type = DEFAULT_TYPE;
            this.name = rawName;
            this.rawName = (this.type + ':' + this.name).intern();
        }
    }

    public ComponentName(String type, String name) {
        this.type = type.intern();
        this.name = name;
        this.rawName = (type + ':' + name).intern();
    }

    public final String getType() {
        return this.type;
    }

    public final String getName() {
        return this.name;
    }

    public final String getRawName() {
        return this.rawName;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ComponentName) {
            return this.rawName.equals(((ComponentName)obj).rawName);
        }
        return false;
    }

    public int hashCode() {
        return this.rawName.hashCode();
    }

    public String toString() {
        return this.rawName;
    }
}

