/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.restlet.data.MediaType;
import org.restlet.resource.OutputRepresentation;
import org.restlet.resource.Representation;

public class ObjectRepresentation
extends OutputRepresentation {
    private Object object;

    public ObjectRepresentation(Representation serializedRepresentation) throws IOException, ClassNotFoundException, IllegalArgumentException {
        super(MediaType.APPLICATION_JAVA_OBJECT);
        if (!serializedRepresentation.getMediaType().equals(MediaType.APPLICATION_JAVA_OBJECT)) {
            throw new IllegalArgumentException("The serialized representation must have this media type: " + MediaType.APPLICATION_JAVA_OBJECT.toString());
        }
        ObjectInputStream ois = new ObjectInputStream(serializedRepresentation.getStream());
        this.object = ois.readObject();
        ois.close();
    }

    public ObjectRepresentation(Serializable object) {
        super(MediaType.APPLICATION_JAVA_OBJECT);
        this.object = object;
    }

    public Object getObject() throws IOException {
        return this.object;
    }

    public void write(OutputStream outputStream) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(outputStream);
        oos.writeObject(this.getObject());
        oos.close();
    }
}

