/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dmk;

import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.GenericHttpConnectorServer;
import com.sun.jdmk.comm.HtmlAdaptorServer;
import com.sun.jdmk.comm.internal.JDMKServerConnector;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.dmk.DmkProtocol;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class DmkComponent
extends DefaultComponent {
    protected final Map<String, DmkProtocol> configs = new HashMap<String, DmkProtocol>();
    protected HtmlAdaptorServer htmlAdaptor;
    protected JDMKServerConnector httpConnector;
    protected JDMKServerConnector httpsConnector;
    protected final Log log = LogFactory.getLog(DmkComponent.class);
    protected final MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();

    protected HtmlAdaptorServer newAdaptor(DmkProtocol config) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        HtmlAdaptorServer adaptor = new HtmlAdaptorServer();
        adaptor.addUserAuthenticationInfo(new AuthInfo(config.user, config.password));
        adaptor.setPort(config.port);
        ObjectName name = new ObjectName("org.nuxeo:type=jmx-adaptor,format=html");
        this.mbs.registerMBean(adaptor, name);
        return adaptor;
    }

    protected void destroyAdaptor(HtmlAdaptorServer adaptor) throws MalformedObjectNameException, MBeanRegistrationException, InstanceNotFoundException {
        ObjectName name = new ObjectName("org.nuxeo:type=jmx-adaptor,format=html");
        this.mbs.unregisterMBean(name);
        if (!adaptor.isActive()) {
            return;
        }
        adaptor.stop();
    }

    protected JDMKServerConnector newConnector(DmkProtocol config) throws IOException, MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        String protocol = "jdmk-".concat(config.name);
        JMXServiceURL httpURL = new JMXServiceURL(protocol, null, config.port);
        JDMKServerConnector connector = (JDMKServerConnector)JMXConnectorServerFactory.newJMXConnectorServer(httpURL, null, this.mbs);
        GenericHttpConnectorServer server = (GenericHttpConnectorServer)connector.getWrapped();
        server.addUserAuthenticationInfo(new AuthInfo(config.user, config.password));
        ObjectName name = new ObjectName("org.nuxeo:type=jmx-connector,protocol=".concat(protocol));
        this.mbs.registerMBean(connector, name);
        return connector;
    }

    protected void destroyConnector(JDMKServerConnector connector) throws MalformedObjectNameException, MBeanRegistrationException, InstanceNotFoundException, IOException {
        String protocol = connector.getAddress().getProtocol();
        ObjectName name = new ObjectName("org.nuxeo:type=jmx-connector,protocol=".concat(protocol));
        this.mbs.unregisterMBean(name);
        if (!connector.isActive()) {
            return;
        }
        connector.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(ComponentContext arg0) throws Exception {
        if (this.htmlAdaptor != null) {
            try {
                this.destroyAdaptor(this.htmlAdaptor);
            }
            finally {
                this.htmlAdaptor = null;
            }
        }
        if (this.httpConnector != null) {
            try {
                this.destroyConnector(this.httpConnector);
            }
            finally {
                this.httpConnector = null;
            }
        }
        if (this.httpsConnector != null) {
            try {
                this.destroyConnector(this.httpsConnector);
            }
            finally {
                this.httpsConnector = null;
            }
        }
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if ("protocols".equals(extensionPoint)) {
            DmkProtocol protocol = (DmkProtocol)contribution;
            this.configs.put(protocol.name, protocol);
        }
    }

    public void applicationStarted(ComponentContext context) throws Exception {
        if (this.configs.containsKey("html")) {
            this.htmlAdaptor = this.newAdaptor(this.configs.get("html"));
            this.log.info((Object)"JMX HTML adaptor available at port 8081 (not active, to be started in JMX console)");
        }
        if (this.configs.containsKey("http")) {
            this.httpConnector = this.newConnector(this.configs.get("http"));
            this.log.info((Object)("JMX HTTP connector available at " + this.httpConnector.getAddress() + " (not active, to be started in JMX console)"));
        }
        if (this.configs.containsKey("https")) {
            this.httpsConnector = this.newConnector(this.configs.get("https"));
            this.log.info((Object)("JMX HTTPS connector available at " + this.httpConnector.getAddress() + " (not active, to be started in JMX console)"));
        }
    }
}

