/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.request;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.ajax4jsf.io.ByteBuffer;
import org.ajax4jsf.io.FastBufferInputStream;
import org.richfaces.request.FileUploadResource;

class FileUploadMemoryResource
extends FileUploadResource {
    private ByteBuffer buffer;

    public FileUploadMemoryResource(String name, String uploadLocation) {
        super(name, uploadLocation);
    }

    private void checkNotDeleted() throws IOException {
        if (this.buffer == null) {
            throw new IOException("Resource has been deleted");
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.checkNotDeleted();
        return new FastBufferInputStream(this.buffer);
    }

    @Override
    public long getSize() {
        return this.buffer.getLast().getTotalSize();
    }

    @Override
    public void write(String fileName) throws IOException {
        this.checkNotDeleted();
        Files.copy(this.getInputStream(), this.getOutputFile(fileName).toPath(), new CopyOption[0]);
    }

    @Override
    public void delete() throws IOException {
        this.buffer = null;
    }

    @Override
    public void handle(byte[] bytes, int length) throws IOException {
        this.buffer.append(bytes, 0, length);
    }

    @Override
    public void create() {
        this.buffer = new ByteBuffer(128);
    }

    @Override
    public void complete() {
        this.buffer.compact();
    }
}

