/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.adapter;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.adapter.DocumentAdapterDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class DocumentAdapterService
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName("service", "org.nuxeo.ecm.core.api.DocumentAdapterService");
    private static final Log log = LogFactory.getLog(DocumentAdapterService.class);
    protected Map<Class<?>, DocumentAdapterDescriptor> adapters;

    public DocumentAdapterDescriptor getAdapterDescriptor(Class<?> itf) {
        return this.adapters.get(itf);
    }

    public DocumentAdapterDescriptor[] getAdapterDescriptors() {
        Collection<DocumentAdapterDescriptor> values = this.adapters.values();
        return values.toArray(new DocumentAdapterDescriptor[values.size()]);
    }

    public void registerAdapterFactory(DocumentAdapterDescriptor dae) {
        this.adapters.put(dae.getInterface(), dae);
        log.info((Object)("Registered document adapter factory " + dae));
    }

    public void unregisterAdapterFactory(Class<?> itf) {
        DocumentAdapterDescriptor dae = this.adapters.remove(itf);
        if (dae != null) {
            log.info((Object)("Unregistered document adapter factory: " + dae));
        }
    }

    public void activate(ComponentContext context) {
        this.adapters = new ConcurrentHashMap();
    }

    public void deactivate(ComponentContext context) {
        this.adapters.clear();
        this.adapters = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals("adapters")) {
            DocumentAdapterDescriptor dae = (DocumentAdapterDescriptor)contribution;
            this.registerAdapterFactory(dae);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals("adapters")) {
            DocumentAdapterDescriptor dae = (DocumentAdapterDescriptor)contribution;
            this.unregisterAdapterFactory(dae.getInterface());
        }
    }
}

