/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.collections.ArrayMap;
import org.nuxeo.common.collections.PrimitiveArrays;
import org.nuxeo.common.collections.ScopeType;
import org.nuxeo.common.collections.ScopedMap;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DataModelMap;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.adapter.DocumentAdapterDescriptor;
import org.nuxeo.ecm.core.api.adapter.DocumentAdapterService;
import org.nuxeo.ecm.core.api.impl.DataModelImpl;
import org.nuxeo.ecm.core.api.impl.DataModelMapImpl;
import org.nuxeo.ecm.core.api.local.ClientLoginModule;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.model.PropertyVisitor;
import org.nuxeo.ecm.core.api.model.impl.DocumentPartImpl;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.Prefetch;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.TypeConstants;
import org.nuxeo.ecm.core.schema.TypeProvider;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.ComplexTypeImpl;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.JavaTypes;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.runtime.api.Framework;

public class DocumentModelImpl
implements DocumentModel,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final String STRICT_LAZY_LOADING_POLICY_KEY = "org.nuxeo.ecm.core.strictlazyloading";
    public static final long F_VERSION = 16L;
    public static final long F_PROXY = 32L;
    public static final long F_IMMUTABLE = 256L;
    private static final Log log = LogFactory.getLog(DocumentModelImpl.class);
    protected String sid;
    protected DocumentRef ref;
    protected DocumentType type;
    protected String typeName;
    protected Set<String> schemas;
    protected Set<String> schemasOrig;
    protected Set<String> facets;
    public Set<String> instanceFacets;
    public Set<String> instanceFacetsOrig;
    protected String id;
    protected Path path;
    protected Long pos;
    protected DataModelMap dataModels;
    protected DocumentRef parentRef;
    protected static final Lock LOCK_UNKNOWN = new Lock(null, null);
    protected Lock lock = LOCK_UNKNOWN;
    protected boolean isStateLoaded;
    protected String currentLifeCycleState;
    protected String lifeCyclePolicy;
    protected boolean isCheckedOut = true;
    protected String versionSeriesId;
    protected boolean isLatestVersion;
    protected boolean isMajorVersion;
    protected boolean isLatestMajorVersion;
    protected boolean isVersionSeriesCheckedOut;
    protected String checkinComment;
    protected transient ACP acp;
    protected transient boolean isACPLoaded = false;
    protected transient ArrayMap<Class<?>, Object> adapters;
    private long flags = 0L;
    protected String repositoryName;
    protected String sourceId;
    private ScopedMap contextData;
    public Prefetch prefetch;
    private String detachedVersionLabel;
    protected static Boolean strictSessionManagement;

    protected DocumentModelImpl() {
    }

    public DocumentModelImpl(String typeName) {
        SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        if (schemaManager == null) {
            throw new NullPointerException("No registered SchemaManager");
        }
        this.type = schemaManager.getDocumentType(typeName);
        this.typeName = typeName;
        this.dataModels = new DataModelMapImpl();
        this.contextData = new ScopedMap();
        this.instanceFacets = new HashSet<String>();
        this.instanceFacetsOrig = new HashSet<String>();
        this.facets = new HashSet<String>();
        this.schemas = new HashSet<String>();
        this.schemasOrig = new HashSet<String>();
    }

    public DocumentModelImpl(String parentPath, String name, String type) {
        this(type);
        String fullPath = parentPath == null ? name : parentPath + (parentPath.endsWith("/") ? "" : "/") + name;
        this.path = new Path(fullPath);
        this.ref = new PathRef(fullPath);
        this.instanceFacets = new HashSet<String>();
        this.instanceFacetsOrig = new HashSet<String>();
        this.facets = new HashSet<String>();
        this.schemas = new HashSet<String>();
        if (this.getDocumentType() != null) {
            this.facets.addAll(this.getDocumentType().getFacets());
        }
        this.schemas = DocumentModelImpl.computeSchemas(this.getDocumentType(), this.instanceFacets, false);
        this.schemasOrig = new HashSet<String>(this.schemas);
    }

    public DocumentModelImpl(String sid, String type, String id, Path path, Lock lock, DocumentRef docRef, DocumentRef parentRef, String[] schemas, Set<String> facets, String sourceId, String repositoryName) {
        this(sid, type, id, path, docRef, parentRef, schemas, facets, sourceId, repositoryName, false);
    }

    public DocumentModelImpl(String sid, String type, String id, Path path, DocumentRef docRef, DocumentRef parentRef, String[] schemas, Set<String> facets, String sourceId, String repositoryName, boolean isProxy) {
        this(type);
        this.sid = sid;
        this.id = id;
        this.path = path;
        this.ref = docRef;
        this.parentRef = parentRef;
        this.instanceFacets = facets == null ? new HashSet<String>() : new HashSet<String>(facets);
        this.instanceFacetsOrig = new HashSet<String>(this.instanceFacets);
        this.facets = new HashSet<String>(this.instanceFacets);
        if (this.getDocumentType() != null) {
            this.facets.addAll(this.getDocumentType().getFacets());
        }
        this.schemas = schemas == null ? DocumentModelImpl.computeSchemas(this.getDocumentType(), this.instanceFacets, isProxy) : new HashSet<String>(Arrays.asList(schemas));
        this.schemasOrig = new HashSet<String>(this.schemas);
        this.repositoryName = repositoryName;
        this.sourceId = sourceId;
        this.setIsProxy(isProxy);
    }

    public static Set<String> computeSchemas(DocumentType type, Collection<String> instanceFacets, boolean isProxy) {
        HashSet<String> schemas = new HashSet<String>();
        if (type != null) {
            schemas.addAll(Arrays.asList(type.getSchemaNames()));
        }
        TypeProvider typeProvider = (TypeProvider)Framework.getLocalService(SchemaManager.class);
        for (String facet : instanceFacets) {
            CompositeType facetType = typeProvider.getFacet(facet);
            if (facetType == null) continue;
            schemas.addAll(Arrays.asList(facetType.getSchemaNames()));
        }
        if (isProxy) {
            for (Schema schema : typeProvider.getProxySchemas(type.getName())) {
                schemas.add(schema.getName());
            }
        }
        return schemas;
    }

    public DocumentModelImpl(DocumentModel parent, String name, String type) {
        this(parent.getPathAsString(), name, type);
    }

    @Override
    public DocumentType getDocumentType() {
        return this.type;
    }

    @Override
    public String getTitle() throws ClientException {
        String title = (String)this.getProperty("dublincore", "title");
        if (title != null) {
            return title;
        }
        title = this.getName();
        if (title != null) {
            return title;
        }
        return this.id;
    }

    @Override
    public String getSessionId() {
        return this.sid;
    }

    @Override
    public DocumentRef getRef() {
        return this.ref;
    }

    @Override
    public DocumentRef getParentRef() {
        if (this.parentRef == null && this.path != null && this.path.isAbsolute()) {
            Path parentPath = this.path.removeLastSegments(1);
            this.parentRef = new PathRef(parentPath.toString());
        }
        return this.parentRef;
    }

    @Override
    public CoreSession getCoreSession() {
        if (this.sid == null) {
            return null;
        }
        try {
            return CoreInstance.getInstance().getSession(this.sid);
        }
        catch (RuntimeException e) {
            String messageTemp = "Try to get session closed %s. Document path %s, user connected %s";
            NuxeoPrincipal principal = ClientLoginModule.getCurrentPrincipal();
            String username = principal == null ? "null" : principal.getName();
            String message = String.format(messageTemp, this.sid, this.getPathAsString(), username);
            log.error((Object)message);
            throw e;
        }
    }

    protected boolean useStrictSessionManagement() {
        if (strictSessionManagement == null) {
            strictSessionManagement = Framework.isBooleanPropertyTrue((String)STRICT_LAZY_LOADING_POLICY_KEY);
        }
        return strictSessionManagement;
    }

    protected CoreSession getTempCoreSession() throws ClientException {
        if (this.sid != null && this.useStrictSessionManagement()) {
            throw new ClientException("Document " + this.id + " is bound to a closed CoreSession, can not reconnect");
        }
        return CoreInstance.openCoreSession(this.repositoryName);
    }

    @Override
    public void detach(boolean loadAll) throws ClientException {
        if (this.sid == null) {
            return;
        }
        if (loadAll) {
            for (String schema : this.schemas) {
                if (this.isSchemaLoaded(schema)) continue;
                this.loadDataModel(schema);
            }
            if (this.ref != null) {
                this.getACP();
            }
            this.detachedVersionLabel = this.getVersionLabel();
            this.isCheckedOut();
            this.getCurrentLifeCycleState();
            this.getLockInfo();
        }
        this.sid = null;
    }

    @Override
    public void attach(String sid) throws ClientException {
        if (this.sid != null) {
            throw new ClientException("Cannot attach a document that is already attached");
        }
        this.sid = sid;
    }

    protected final DataModel loadDataModel(String schema) throws ClientException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("lazy loading of schema " + schema + " for doc " + this.toString()));
        }
        if (!this.schemas.contains(schema)) {
            return null;
        }
        if (!this.schemasOrig.contains(schema)) {
            DataModelImpl dataModel = new DataModelImpl(schema);
            this.dataModels.put(schema, dataModel);
            return dataModel;
        }
        if (this.sid == null) {
            DataModelImpl dataModel = new DataModelImpl(schema);
            this.dataModels.put(schema, dataModel);
            return dataModel;
        }
        if (this.ref == null) {
            return null;
        }
        if (this.getCoreSession() == null && this.useStrictSessionManagement()) {
            log.warn((Object)("DocumentModel " + this.id + " is bound to a null or closed session, " + "lazy loading is not available"));
            return null;
        }
        TypeProvider typeProvider = (TypeProvider)Framework.getLocalService(SchemaManager.class);
        final Schema schemaType = typeProvider.getSchema(schema);
        DataModel dataModel = (DataModel)new RunWithCoreSession<DataModel>(){

            @Override
            public DataModel run() throws ClientException {
                return this.session.getDataModel(DocumentModelImpl.this.ref, schemaType);
            }
        }.execute();
        this.dataModels.put(schema, dataModel);
        return dataModel;
    }

    @Override
    public DataModel getDataModel(String schema) throws ClientException {
        DataModel dataModel = (DataModel)this.dataModels.get(schema);
        if (dataModel == null) {
            dataModel = this.loadDataModel(schema);
        }
        return dataModel;
    }

    @Override
    public Collection<DataModel> getDataModelsCollection() {
        return this.dataModels.values();
    }

    public void addDataModel(DataModel dataModel) {
        this.dataModels.put(dataModel.getSchema(), dataModel);
    }

    @Override
    public String[] getSchemas() {
        return this.schemas.toArray(new String[this.schemas.size()]);
    }

    @Override
    @Deprecated
    public String[] getDeclaredSchemas() {
        return this.getSchemas();
    }

    @Override
    public boolean hasSchema(String schema) {
        return this.schemas.contains(schema);
    }

    @Override
    public Set<String> getFacets() {
        return Collections.unmodifiableSet(this.facets);
    }

    @Override
    public boolean hasFacet(String facet) {
        return this.facets.contains(facet);
    }

    @Override
    @Deprecated
    public Set<String> getDeclaredFacets() {
        return this.getFacets();
    }

    @Override
    public boolean addFacet(String facet) {
        if (facet == null) {
            throw new ClientRuntimeException("Null facet");
        }
        if (this.facets.contains(facet)) {
            return false;
        }
        TypeProvider typeProvider = (TypeProvider)Framework.getLocalService(SchemaManager.class);
        CompositeType facetType = typeProvider.getFacet(facet);
        if (facetType == null) {
            throw new ClientRuntimeException("No such facet: " + facet);
        }
        this.facets.add(facet);
        this.instanceFacets.add(facet);
        this.schemas.addAll(Arrays.asList(facetType.getSchemaNames()));
        return true;
    }

    @Override
    public boolean removeFacet(String facet) {
        if (facet == null) {
            throw new ClientRuntimeException("Null facet");
        }
        if (!this.instanceFacets.contains(facet)) {
            return false;
        }
        this.facets.remove(facet);
        this.instanceFacets.remove(facet);
        HashSet<String> droppedSchemas = new HashSet<String>(this.schemas);
        this.schemas = DocumentModelImpl.computeSchemas(this.getDocumentType(), this.instanceFacets, this.isProxy());
        droppedSchemas.removeAll(this.schemas);
        for (String s : droppedSchemas) {
            this.dataModels.remove(s);
        }
        return true;
    }

    protected static Set<String> inferFacets(Set<String> facets, DocumentType documentType) {
        if (facets == null) {
            facets = new HashSet<String>();
            if (documentType != null) {
                facets.addAll(documentType.getFacets());
            }
        }
        return facets;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        if (this.path != null) {
            return this.path.lastSegment();
        }
        return null;
    }

    @Override
    public Long getPos() {
        return this.pos;
    }

    public void setPosInternal(Long pos) {
        this.pos = pos;
    }

    @Override
    public String getPathAsString() {
        if (this.path != null) {
            return this.path.toString();
        }
        return null;
    }

    @Override
    public Map<String, Object> getProperties(String schemaName) throws ClientException {
        DataModel dm = this.getDataModel(schemaName);
        return dm == null ? null : dm.getMap();
    }

    @Override
    public Object getProperty(String schemaName, String name) throws ClientException {
        Serializable value;
        if (this.prefetch != null && (value = this.prefetch.get(schemaName, name)) != ObjectUtils.NULL) {
            return value;
        }
        DataModel dm = (DataModel)this.dataModels.get(schemaName);
        if (dm == null) {
            dm = this.getDataModel(schemaName);
        }
        return dm == null ? null : dm.getData(name);
    }

    @Override
    public void setPathInfo(String parentPath, String name) {
        this.path = new Path(parentPath == null ? name : parentPath + '/' + name);
        this.ref = new PathRef(parentPath, name);
    }

    protected String oldLockKey(Lock lock) {
        if (lock == null) {
            return null;
        }
        String lockCreationDate = lock.getCreated() == null ? null : DateFormat.getDateInstance(2).format(new Date(lock.getCreated().getTimeInMillis()));
        return lock.getOwner() + ':' + lockCreationDate;
    }

    @Override
    @Deprecated
    public String getLock() {
        try {
            return this.oldLockKey(this.getLockInfo());
        }
        catch (ClientException e) {
            throw new ClientRuntimeException(e);
        }
    }

    @Override
    public boolean isLocked() {
        try {
            return this.getLockInfo() != null;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException(e);
        }
    }

    @Override
    @Deprecated
    public void setLock(String key) throws ClientException {
        this.setLock();
    }

    @Override
    public void unlock() throws ClientException {
        this.removeLock();
    }

    @Override
    public Lock setLock() throws ClientException {
        Lock newLock;
        this.lock = newLock = (Lock)new RunWithCoreSession<Lock>(){

            @Override
            public Lock run() throws ClientException {
                return this.session.setLock(DocumentModelImpl.this.ref);
            }
        }.execute();
        return this.lock;
    }

    @Override
    public Lock getLockInfo() throws ClientException {
        if (this.lock != LOCK_UNKNOWN) {
            return this.lock;
        }
        CoreSession session = this.getCoreSession();
        if (session == null) {
            return null;
        }
        this.lock = session.getLockInfo(this.ref);
        return this.lock;
    }

    @Override
    public Lock removeLock() throws ClientException {
        Lock oldLock = (Lock)new RunWithCoreSession<Lock>(){

            @Override
            public Lock run() throws ClientException {
                return this.session.removeLock(DocumentModelImpl.this.ref);
            }
        }.execute();
        this.lock = null;
        return oldLock;
    }

    @Override
    public boolean isCheckedOut() throws ClientException {
        if (!this.isStateLoaded) {
            if (this.getCoreSession() == null) {
                return true;
            }
            this.refresh(1, null);
        }
        return this.isCheckedOut;
    }

    @Override
    public void checkOut() throws ClientException {
        this.getCoreSession().checkOut(this.ref);
        this.isStateLoaded = false;
        this.refresh(64, null);
    }

    @Override
    public DocumentRef checkIn(VersioningOption option, String description) throws ClientException {
        DocumentRef versionRef = this.getCoreSession().checkIn(this.ref, option, description);
        this.isStateLoaded = false;
        this.refresh(64, null);
        return versionRef;
    }

    @Override
    public String getVersionLabel() {
        if (this.detachedVersionLabel != null) {
            return this.detachedVersionLabel;
        }
        if (this.getCoreSession() == null) {
            return null;
        }
        try {
            return this.getCoreSession().getVersionLabel(this);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException(e);
        }
    }

    @Override
    public String getVersionSeriesId() throws ClientException {
        if (!this.isStateLoaded) {
            this.refresh(1, null);
        }
        return this.versionSeriesId;
    }

    @Override
    public boolean isLatestVersion() throws ClientException {
        if (!this.isStateLoaded) {
            this.refresh(1, null);
        }
        return this.isLatestVersion;
    }

    @Override
    public boolean isMajorVersion() throws ClientException {
        if (!this.isStateLoaded) {
            this.refresh(1, null);
        }
        return this.isMajorVersion;
    }

    @Override
    public boolean isLatestMajorVersion() throws ClientException {
        if (!this.isStateLoaded) {
            this.refresh(1, null);
        }
        return this.isLatestMajorVersion;
    }

    @Override
    public boolean isVersionSeriesCheckedOut() throws ClientException {
        if (!this.isStateLoaded) {
            this.refresh(1, null);
        }
        return this.isVersionSeriesCheckedOut;
    }

    @Override
    public String getCheckinComment() throws ClientException {
        if (!this.isStateLoaded) {
            this.refresh(1, null);
        }
        return this.checkinComment;
    }

    @Override
    public ACP getACP() throws ClientException {
        if (!this.isACPLoaded) {
            this.acp = (ACP)new RunWithCoreSession<ACP>(){

                @Override
                public ACP run() throws ClientException {
                    return this.session.getACP(DocumentModelImpl.this.ref);
                }
            }.execute();
            this.isACPLoaded = true;
        }
        return this.acp;
    }

    @Override
    public void setACP(final ACP acp, final boolean overwrite) throws ClientException {
        new RunWithCoreSession<Object>(){

            @Override
            public Object run() throws ClientException {
                this.session.setACP(DocumentModelImpl.this.ref, acp, overwrite);
                return null;
            }
        }.execute();
        this.isACPLoaded = false;
    }

    @Override
    public String getType() {
        return this.typeName;
    }

    @Override
    public void setProperties(String schemaName, Map<String, Object> data) throws ClientException {
        DataModel dm = this.getDataModel(schemaName);
        if (dm != null) {
            dm.setMap(data);
            this.clearPrefetch(schemaName);
        }
    }

    @Override
    public void setProperty(String schemaName, String name, Object value) throws ClientException {
        DataModel dm = this.getDataModel(schemaName);
        if (dm == null) {
            return;
        }
        dm.setData(name, value);
        this.clearPrefetch(schemaName);
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public DataModelMap getDataModels() {
        return this.dataModels;
    }

    @Override
    public boolean isFolder() {
        return this.hasFacet("Folderish");
    }

    @Override
    public boolean isVersionable() {
        return this.hasFacet("Versionable");
    }

    @Override
    public boolean isDownloadable() throws ClientException {
        Long size;
        if (this.hasFacet("Downloadable") && (size = (Long)this.getProperty("common", "size")) != null) {
            return size != 0L;
        }
        return false;
    }

    @Override
    public void accept(PropertyVisitor visitor, Object arg) throws ClientException {
        for (DocumentPart dp : this.getParts()) {
            ((DocumentPartImpl)dp).visitChildren(visitor, arg);
        }
    }

    @Override
    public <T> T getAdapter(Class<T> itf) {
        Object facet = this.getAdapters().get(itf);
        if (facet == null && (facet = this.findAdapter(itf)) != null) {
            this.adapters.put(itf, facet);
        }
        return (T)facet;
    }

    private ArrayMap<Class<?>, Object> getAdapters() {
        if (this.adapters == null) {
            this.adapters = new ArrayMap();
        }
        return this.adapters;
    }

    @Override
    public <T> T getAdapter(Class<T> itf, boolean refreshCache) {
        T facet = !refreshCache ? this.getAdapter(itf) : this.findAdapter(itf);
        if (facet != null) {
            this.getAdapters().put(itf, facet);
        }
        return facet;
    }

    private <T> T findAdapter(Class<T> itf) {
        DocumentAdapterService svc = (DocumentAdapterService)((Object)Framework.getService(DocumentAdapterService.class));
        if (svc != null) {
            DocumentAdapterDescriptor dae = svc.getAdapterDescriptor(itf);
            if (dae != null) {
                String facet = dae.getFacet();
                if (facet == null) {
                    return (T)dae.getFactory().getAdapter(this, itf);
                }
                if (this.hasFacet(facet)) {
                    return (T)dae.getFactory().getAdapter(this, itf);
                }
                log.error((Object)("Document model cannot be adapted to " + itf + " because it has no facet " + facet));
            }
        } else {
            log.warn((Object)("DocumentAdapterService not available. Cannot get document model adaptor for " + itf));
        }
        return null;
    }

    @Override
    public boolean followTransition(final String transition) throws ClientException {
        boolean res = (Boolean)new RunWithCoreSession<Boolean>(){

            @Override
            public Boolean run() throws ClientException {
                return this.session.followTransition(DocumentModelImpl.this.ref, transition);
            }
        }.execute();
        if (res) {
            this.currentLifeCycleState = null;
        }
        return res;
    }

    @Override
    public Collection<String> getAllowedStateTransitions() throws ClientException {
        return (Collection)new RunWithCoreSession<Collection<String>>(){

            @Override
            public Collection<String> run() throws ClientException {
                return this.session.getAllowedStateTransitions(DocumentModelImpl.this.ref);
            }
        }.execute();
    }

    @Override
    public String getCurrentLifeCycleState() throws ClientException {
        if (this.currentLifeCycleState != null) {
            return this.currentLifeCycleState;
        }
        if (this.sid == null) {
            return null;
        }
        this.currentLifeCycleState = (String)new RunWithCoreSession<String>(){

            @Override
            public String run() throws ClientException {
                return this.session.getCurrentLifeCycleState(DocumentModelImpl.this.ref);
            }
        }.execute();
        return this.currentLifeCycleState;
    }

    @Override
    public String getLifeCyclePolicy() throws ClientException {
        if (this.lifeCyclePolicy != null) {
            return this.lifeCyclePolicy;
        }
        this.lifeCyclePolicy = (String)new RunWithCoreSession<String>(){

            @Override
            public String run() throws ClientException {
                return this.session.getLifeCyclePolicy(DocumentModelImpl.this.ref);
            }
        }.execute();
        return this.lifeCyclePolicy;
    }

    @Override
    public boolean isVersion() {
        return (this.flags & 0x10L) != 0L;
    }

    @Override
    public boolean isProxy() {
        return (this.flags & 0x20L) != 0L;
    }

    @Override
    public boolean isImmutable() {
        return (this.flags & 0x100L) != 0L;
    }

    public void setIsVersion(boolean isVersion) {
        this.flags = isVersion ? (this.flags |= 0x10L) : (this.flags &= 0xFFFFFFFFFFFFFFEFL);
    }

    public void setIsProxy(boolean isProxy) {
        this.flags = isProxy ? (this.flags |= 0x20L) : (this.flags &= 0xFFFFFFFFFFFFFFDFL);
    }

    public void setIsImmutable(boolean isImmutable) {
        this.flags = isImmutable ? (this.flags |= 0x100L) : (this.flags &= 0xFFFFFFFFFFFFFEFFL);
    }

    @Override
    public boolean isDirty() {
        for (DataModel dm : this.dataModels.values()) {
            DocumentPart part = ((DataModelImpl)dm).getDocumentPart();
            if (!part.isDirty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ScopedMap getContextData() {
        return this.contextData;
    }

    @Override
    public Serializable getContextData(ScopeType scope, String key) {
        return this.contextData.getScopedValue(scope, key);
    }

    @Override
    public void putContextData(ScopeType scope, String key, Serializable value) {
        this.contextData.putScopedValue(scope, key, value);
    }

    @Override
    public Serializable getContextData(String key) {
        return this.contextData.getScopedValue(key);
    }

    @Override
    public void putContextData(String key, Serializable value) {
        this.contextData.putScopedValue(key, value);
    }

    @Override
    public void copyContextData(DocumentModel otherDocument) {
        ScopedMap otherMap = otherDocument.getContextData();
        if (otherMap != null) {
            this.contextData.putAll((Map)otherMap);
        }
    }

    @Override
    public void copyContent(DocumentModel sourceDoc) throws ClientException {
        this.computeFacetsAndSchemas(((DocumentModelImpl)sourceDoc).instanceFacets);
        DataModelMapImpl newDataModels = new DataModelMapImpl();
        for (String key : this.schemas) {
            DataModel newDM;
            DataModel oldDM = sourceDoc.getDataModel(key);
            if (oldDM != null) {
                newDM = this.cloneDataModel(oldDM);
            } else {
                Schema schema = ((SchemaManager)Framework.getService(SchemaManager.class)).getSchema(key);
                newDM = new DataModelImpl(new DocumentPartImpl(schema));
            }
            newDataModels.put(key, newDM);
        }
        this.dataModels = newDataModels;
    }

    public static Object cloneField(Field field, String key, Object value) {
        Object clone;
        Type type = field.getType();
        if (type.isSimpleType()) {
            if (value instanceof Calendar) {
                Calendar newValue = (Calendar)((Object)value);
                clone = newValue.clone();
            } else {
                clone = value;
            }
        } else if (type.isListType()) {
            ListType ltype = (ListType)type;
            Field lfield = ltype.getField();
            Type ftype = lfield.getType();
            List<Object> list = value instanceof Object[] ? Arrays.asList((Object[])value) : (List<Object>)((Object)value);
            if (ftype.isComplexType()) {
                Object[] clonedList = new ArrayList(list.size());
                for (Object o : list) {
                    clonedList.add(DocumentModelImpl.cloneField(lfield, null, o));
                }
                clone = clonedList;
            } else {
                Class klass = JavaTypes.getClass((Type)ftype);
                clone = klass.isPrimitive() ? PrimitiveArrays.toPrimitiveArray(list, (Class)klass) : list.toArray((Object[])Array.newInstance(klass, list.size()));
            }
        } else {
            ComplexType ctype = (ComplexType)type;
            if (TypeConstants.isContentType((Type)ctype)) {
                Blob blob = (Blob)((Object)value);
                clone = blob;
            } else {
                Map map = value;
                HashMap<String, Object> clonedMap = new HashMap<String, Object>();
                for (Map.Entry entry : map.entrySet()) {
                    Object v = entry.getValue();
                    String k = (String)entry.getKey();
                    if (v == null) continue;
                    clonedMap.put(k, DocumentModelImpl.cloneField(ctype.getField(k), k, v));
                }
                clone = clonedMap;
            }
        }
        return clone;
    }

    public static DataModel cloneDataModel(Schema schema, DataModel data) {
        DataModelImpl dm = new DataModelImpl(schema.getName());
        for (Field field : schema.getFields()) {
            Object value;
            String key = field.getName().getLocalName();
            try {
                value = data.getData(key);
            }
            catch (PropertyException e1) {
                continue;
            }
            if (value == null) continue;
            Object clone = DocumentModelImpl.cloneField(field, key, value);
            try {
                dm.setData(key, clone);
            }
            catch (PropertyException e) {
                throw new ClientRuntimeException(e);
            }
        }
        return dm;
    }

    public DataModel cloneDataModel(DataModel data) {
        TypeProvider typeProvider = (TypeProvider)Framework.getLocalService(SchemaManager.class);
        return DocumentModelImpl.cloneDataModel(typeProvider.getSchema(data.getSchema()), data);
    }

    @Override
    public String getCacheKey() throws ClientException {
        Calendar timeStamp;
        String key = this.id + '-' + this.sid + '-' + this.getPathAsString();
        if (this.hasSchema("dublincore") && (timeStamp = (Calendar)this.getProperty("dublincore", "modified")) != null) {
            timeStamp.set(14, 0);
            key = key + '-' + String.valueOf(timeStamp.getTimeInMillis());
        }
        return key;
    }

    @Override
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @Override
    public String getSourceId() {
        return this.sourceId;
    }

    public boolean isSchemaLoaded(String name) {
        return this.dataModels.containsKey(name);
    }

    @Override
    public boolean isPrefetched(String xpath) {
        return this.prefetch != null && this.prefetch.isPrefetched(xpath);
    }

    @Override
    public boolean isPrefetched(String schemaName, String name) {
        return this.prefetch != null && this.prefetch.isPrefetched(schemaName, name);
    }

    public void setPrefetch(Prefetch prefetch) {
        this.prefetch = prefetch;
    }

    @Override
    public void prefetchCurrentLifecycleState(String lifecycle) {
        this.currentLifeCycleState = lifecycle;
    }

    @Override
    public void prefetchLifeCyclePolicy(String lifeCyclePolicy) {
        this.lifeCyclePolicy = lifeCyclePolicy;
    }

    public boolean equals(Object obj) {
        DocumentModel documentModel;
        String id;
        if (obj == this) {
            return true;
        }
        if (obj instanceof DocumentModelImpl && (id = (documentModel = (DocumentModel)obj).getId()) != null) {
            return id.equals(this.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    public String toString() {
        String title = this.id;
        try {
            if (this.getDataModels().containsKey("dublincore")) {
                title = this.getTitle();
            }
        }
        catch (ClientException e) {
            title = "(ERROR: " + e + ')';
        }
        return this.getClass().getSimpleName() + '(' + this.id + ", path=" + this.path + ", title=" + title + ')';
    }

    @Override
    public <T extends Serializable> T getSystemProp(final String systemProperty, final Class<T> type) throws ClientException, DocumentException {
        return (T)((Serializable)new RunWithCoreSession<T>(){

            @Override
            public T run() throws ClientException {
                try {
                    return this.session.getDocumentSystemProp(DocumentModelImpl.this.ref, systemProperty, type);
                }
                catch (DocumentException e) {
                    throw new ClientException(e);
                }
            }
        }.execute());
    }

    @Override
    public boolean isLifeCycleLoaded() {
        return this.currentLifeCycleState != null;
    }

    @Override
    public DocumentPart getPart(String schema) throws ClientException {
        DataModel dm = this.getDataModel(schema);
        if (dm != null) {
            return ((DataModelImpl)dm).getDocumentPart();
        }
        return null;
    }

    @Override
    public DocumentPart[] getParts() throws ClientException {
        DocumentPart[] parts = new DocumentPart[this.schemas.size()];
        int i = 0;
        for (String schema : this.schemas) {
            DataModel dm = this.getDataModel(schema);
            parts[i++] = ((DataModelImpl)dm).getDocumentPart();
        }
        return parts;
    }

    @Override
    public Property getProperty(String xpath) throws ClientException {
        if (xpath == null) {
            throw new PropertyNotFoundException("null", "Invalid null xpath");
        }
        String cxpath = ComplexTypeImpl.canonicalXPath((String)xpath);
        if (cxpath.isEmpty()) {
            throw new PropertyNotFoundException(xpath, "Schema not specified");
        }
        String schemaName = DocumentModelImpl.getXPathSchemaName(cxpath, this.schemas, null);
        if (schemaName == null) {
            if (cxpath.indexOf(58) != -1) {
                throw new PropertyNotFoundException(xpath, "No such schema");
            }
            throw new PropertyNotFoundException(xpath);
        }
        DocumentPart part = this.getPart(schemaName);
        if (part == null) {
            throw new PropertyNotFoundException(xpath);
        }
        String partPath = cxpath.substring(cxpath.indexOf(58) + 1);
        try {
            return part.resolvePath(partPath);
        }
        catch (PropertyNotFoundException e) {
            throw new PropertyNotFoundException(xpath, e.getDetail());
        }
    }

    public static String getXPathSchemaName(String xpath, Set<String> docSchemas, String[] returnName) {
        SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        int i = xpath.indexOf(47);
        String prop = i == -1 ? xpath : xpath.substring(0, i);
        int p = prop.indexOf(58);
        if (p != -1) {
            String prefix = prop.substring(0, p);
            Schema schema = schemaManager.getSchemaFromPrefix(prefix);
            if (schema == null && (schema = schemaManager.getSchema(prefix)) == null) {
                return null;
            }
            if (returnName != null) {
                returnName[0] = prop.substring(p + 1);
            }
            return schema.getName();
        }
        for (String schemaName : docSchemas) {
            Schema schema = schemaManager.getSchema(schemaName);
            if (schema == null || !schema.hasField(prop)) continue;
            if (returnName != null) {
                returnName[0] = prop;
            }
            return schema.getName();
        }
        return null;
    }

    @Override
    public Serializable getPropertyValue(String xpath) throws PropertyException, ClientException {
        Serializable value;
        if (this.prefetch != null && (value = this.prefetch.get(xpath)) != ObjectUtils.NULL) {
            return value;
        }
        return this.getProperty(xpath).getValue();
    }

    @Override
    public void setPropertyValue(String xpath, Serializable value) throws PropertyException, ClientException {
        this.getProperty(xpath).setValue(value);
        this.clearPrefetchXPath(xpath);
    }

    private void clearPrefetch(String schemaName) {
        if (this.prefetch != null) {
            this.prefetch.clearPrefetch(schemaName);
            if (this.prefetch.isEmpty()) {
                this.prefetch = null;
            }
        }
    }

    protected void clearPrefetchXPath(String xpath) {
        String schemaName;
        if (this.prefetch != null && (schemaName = this.prefetch.getXPathSchema(xpath, this.getDocumentType())) != null) {
            this.clearPrefetch(schemaName);
        }
    }

    @Override
    public DocumentModel clone() throws CloneNotSupportedException {
        DocumentModelImpl dm = (DocumentModelImpl)super.clone();
        dm.facets = new HashSet<String>(this.facets);
        dm.contextData = new ScopedMap();
        dm.dataModels = new DataModelMapImpl();
        for (Map.Entry entry : this.dataModels.entrySet()) {
            DataModelImpl newData;
            String key = (String)entry.getKey();
            DataModel data = (DataModel)entry.getValue();
            try {
                newData = new DataModelImpl(key, data.getMap());
            }
            catch (PropertyException e) {
                throw new ClientRuntimeException(e);
            }
            dm.dataModels.put(key, newData);
        }
        return dm;
    }

    @Override
    public void reset() {
        if (this.dataModels != null) {
            this.dataModels.clear();
        }
        this.prefetch = null;
        this.isACPLoaded = false;
        this.acp = null;
        this.currentLifeCycleState = null;
        this.lifeCyclePolicy = null;
    }

    @Override
    public void refresh() throws ClientException {
        this.detachedVersionLabel = null;
        this.refresh(141, null);
    }

    @Override
    public void refresh(int refreshFlags, String[] schemas) throws ClientException {
        DocumentPart[] parts;
        if (this.id == null) {
            return;
        }
        if ((refreshFlags & 8) != 0 && this.isACPLoaded) {
            refreshFlags |= 0x20;
        }
        if ((refreshFlags & 0x40) != 0) {
            refreshFlags |= 0x100;
            Set keys = this.dataModels.keySet();
            schemas = keys.toArray(new String[keys.size()]);
        }
        DocumentModel.DocumentModelRefresh refresh = this.getCoreSession().refreshDocument(this.ref, refreshFlags, schemas);
        if ((refreshFlags & 4) != 0) {
            this.prefetch = refresh.prefetch;
        }
        if ((refreshFlags & 1) != 0) {
            this.currentLifeCycleState = refresh.lifeCycleState;
            this.lifeCyclePolicy = refresh.lifeCyclePolicy;
            this.isCheckedOut = refresh.isCheckedOut;
            this.isLatestVersion = refresh.isLatestVersion;
            this.isMajorVersion = refresh.isMajorVersion;
            this.isLatestMajorVersion = refresh.isLatestMajorVersion;
            this.isVersionSeriesCheckedOut = refresh.isVersionSeriesCheckedOut;
            this.versionSeriesId = refresh.versionSeriesId;
            this.checkinComment = refresh.checkinComment;
            this.isStateLoaded = true;
        }
        this.acp = null;
        this.isACPLoaded = false;
        if ((refreshFlags & 0x20) != 0) {
            this.acp = refresh.acp;
            this.isACPLoaded = true;
        }
        if ((refreshFlags & 0x180) != 0) {
            this.dataModels.clear();
            this.computeFacetsAndSchemas(refresh.instanceFacets);
        }
        if ((refreshFlags & 0x100) != 0 && (parts = refresh.documentParts) != null) {
            for (DocumentPart part : parts) {
                DataModelImpl dm = new DataModelImpl(part);
                this.dataModels.put(dm.getSchema(), dm);
            }
        }
    }

    protected void computeFacetsAndSchemas(Set<String> instanceFacets) {
        this.instanceFacets = instanceFacets;
        this.instanceFacetsOrig = new HashSet<String>(instanceFacets);
        this.facets = new HashSet<String>(instanceFacets);
        this.facets.addAll(this.getDocumentType().getFacets());
        if (this.isImmutable()) {
            this.facets.add("Immutable");
        }
        this.schemas = DocumentModelImpl.computeSchemas(this.getDocumentType(), instanceFacets, this.isProxy());
        this.schemasOrig = new HashSet<String>(this.schemas);
    }

    @Override
    public String getChangeToken() {
        if (!this.hasSchema("dublincore")) {
            return null;
        }
        try {
            Calendar modified = (Calendar)this.getProperty("dublincore", "modified");
            if (modified != null) {
                return new Long(modified.getTimeInMillis()).toString();
            }
        }
        catch (ClientException e) {
            log.error((Object)"Error while retrieving dc:modified", (Throwable)e);
        }
        return null;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Map<String, String> getBinaryFulltext() throws ClientException {
        CoreSession session = this.getCoreSession();
        if (session == null) {
            return null;
        }
        return session.getBinaryFulltext(this.ref);
    }

    protected abstract class RunWithCoreSession<T> {
        public CoreSession session;

        protected RunWithCoreSession() {
        }

        public abstract T run() throws ClientException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T execute() throws ClientException {
            this.session = DocumentModelImpl.this.getCoreSession();
            if (this.session != null) {
                return this.run();
            }
            this.session = DocumentModelImpl.this.getTempCoreSession();
            try {
                T t = this.run();
                return t;
            }
            finally {
                try {
                    this.session.save();
                }
                finally {
                    this.session.close();
                }
            }
        }
    }
}

