/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model;

import org.nuxeo.ecm.core.api.model.Delta;

public class DeltaLong
extends Delta {
    private static final long serialVersionUID = 1L;
    private final long base;
    private final long delta;

    public DeltaLong(long base, long delta) {
        this.base = base;
        this.delta = delta;
    }

    public static Number deltaOrLong(Number base, long delta) {
        if (base == null) {
            return delta;
        }
        if (base instanceof Long) {
            return new DeltaLong(base.longValue(), delta);
        }
        if (base instanceof DeltaLong) {
            DeltaLong dl = (DeltaLong)base;
            if (delta == 0L) {
                return dl;
            }
            return new DeltaLong(dl.getBase(), dl.getDelta() + delta);
        }
        throw new IllegalArgumentException(base.getClass().getName());
    }

    @Override
    public Delta add(Delta other) {
        if (!(other instanceof DeltaLong)) {
            throw new IllegalArgumentException("Cannot add " + this.getClass().getSimpleName() + " and " + other.getClass().getSimpleName());
        }
        return new DeltaLong(this.base, this.delta + ((DeltaLong)other).delta);
    }

    @Override
    public Number add(Number other) {
        if (!(other instanceof Long)) {
            throw new IllegalArgumentException("Cannot add " + this.getClass().getSimpleName() + " and " + other.getClass().getSimpleName());
        }
        return (Long)other + this.delta;
    }

    public long getBase() {
        return this.base;
    }

    public long getDelta() {
        return this.delta;
    }

    @Override
    public Long getDeltaValue() {
        return this.delta;
    }

    @Override
    public Long getFullValue() {
        return this.longValue();
    }

    @Override
    public long longValue() {
        return this.base + this.delta;
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    public float floatValue() {
        return this.longValue();
    }

    @Override
    public double doubleValue() {
        return this.longValue();
    }

    public String toString() {
        return Long.toString(this.longValue());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DeltaLong) {
            DeltaLong dl = (DeltaLong)obj;
            return this.base == dl.base && this.delta == dl.delta;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 31 + (int)(this.base ^ this.base >>> 32);
        return 31 * result + (int)(this.delta ^ this.delta >>> 32);
    }
}

