/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.multi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.directory.AbstractReference;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryEntryNotFoundException;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.multi.MultiDirectory;
import org.nuxeo.ecm.directory.multi.MultiDirectoryFactory;
import org.nuxeo.ecm.directory.multi.SourceDescriptor;
import org.nuxeo.ecm.directory.multi.SubDirectoryDescriptor;

public class MultiReference
extends AbstractReference {
    private static final Log log = LogFactory.getLog(MultiReference.class);
    final MultiDirectory dir;
    final String fieldName;

    MultiReference(MultiDirectory dir, String fieldName) {
        this.dir = dir;
        this.fieldName = fieldName;
    }

    public void addLinks(String sourceId, List<String> targetIds) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    public void addLinks(List<String> sourceIds, String targetId) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    protected List<String> doCollect(Collector extractor) throws DirectoryException {
        HashSet<String> ids = new HashSet<String>();
        for (SourceDescriptor src : this.dir.getDescriptor().sources) {
            for (SubDirectoryDescriptor sub : src.subDirectories) {
                List ref;
                Directory dir = MultiDirectoryFactory.getDirectoryService().getDirectory(sub.name);
                if (dir == null || (ref = dir.getReferences(this.fieldName)) == null) continue;
                try {
                    ids.addAll(extractor.collect(ref));
                }
                catch (DirectoryEntryNotFoundException e) {
                    log.debug((Object)e.getMessage());
                }
            }
        }
        ArrayList<String> x = new ArrayList<String>(ids.size());
        x.addAll(ids);
        return x;
    }

    public List<String> getSourceIdsForTarget(final String targetId) throws DirectoryException {
        return this.doCollect(new Collector(){

            @Override
            public List<String> collect(List<Reference> refs) throws DirectoryException {
                ArrayList<String> sourceIds = new ArrayList<String>(1);
                for (Reference ref : refs) {
                    sourceIds.addAll(ref.getSourceIdsForTarget(targetId));
                }
                return sourceIds;
            }
        });
    }

    public List<String> getTargetIdsForSource(final String sourceId) throws DirectoryException {
        return this.doCollect(new Collector(){

            @Override
            public List<String> collect(List<Reference> refs) throws DirectoryException {
                ArrayList<String> targetIds = new ArrayList<String>(1);
                for (Reference ref : refs) {
                    targetIds.addAll(ref.getSourceIdsForTarget(sourceId));
                }
                return targetIds;
            }
        });
    }

    public void removeLinksForSource(String sourceId) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    public void removeLinksForTarget(String targetId) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    public void setSourceIdsForTarget(String targetId, List<String> sourceIds) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    public void setTargetIdsForSource(String sourceId, List<String> targetIds) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    protected AbstractReference newInstance() {
        return new MultiReference(this.dir, this.fieldName);
    }

    public AbstractReference clone() {
        return super.clone();
    }

    protected static interface Collector {
        public List<String> collect(List<Reference> var1) throws DirectoryException;
    }
}

