/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.util;

import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.util.IntegerDecoderException;

public class IntegerDecoder {
    private static final int[] MASK = new int[]{255, 65535, 0xFFFFFF, -1};

    public static int parse(Value value, int min, int max) throws IntegerDecoderException {
        int result = 0;
        byte[] bytes = value.getData();
        if (bytes == null || bytes.length == 0) {
            throw new IntegerDecoderException("The value is 0 byte long. This is not allowed for an integer");
        }
        if (bytes.length > 4) {
            throw new IntegerDecoderException("The value is more than 4 bytes long. This is not allowed for an integer");
        }
        for (int i = 0; i < bytes.length && i < 5; ++i) {
            result = result << 8 | bytes[i] & 0xFF;
        }
        if ((bytes[0] & 0x80) == 128) {
            result = -(~result + 1 & MASK[bytes.length - 1]);
        }
        if (result >= min && result <= max) {
            return result;
        }
        throw new IntegerDecoderException("The value is not in the range [" + min + ", " + max + "]");
    }

    public static int parse(Value value) throws IntegerDecoderException {
        return IntegerDecoder.parse(value, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }
}

