/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.mail;

import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.File;
import java.io.FileInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.ecm.automation.core.mail.BlobDataSource;
import org.nuxeo.ecm.automation.core.mail.Mailer;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.platform.rendering.api.RenderingException;
import org.nuxeo.ecm.platform.rendering.api.ResourceLocator;
import org.nuxeo.ecm.platform.rendering.fm.FreemarkerEngine;
import org.nuxeo.runtime.api.Framework;

public class Composer {
    private static final Log log = LogFactory.getLog(Composer.class);
    protected final FreemarkerEngine engine;
    protected Mailer mailer;
    protected final ConcurrentMap<String, URL> urls = new ConcurrentHashMap<String, URL>();

    public Composer() {
        this(null);
    }

    public Composer(Mailer mailer) {
        this.mailer = mailer == null ? this.createMailer() : mailer;
        this.engine = new FreemarkerEngine();
        this.engine.setResourceLocator(new ResourceLocator(){

            public URL getResourceURL(String key) {
                return (URL)Composer.this.urls.get(key);
            }

            public File getResourceFile(String key) {
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Mailer createMailer() {
        File file;
        Environment env = Environment.getDefault();
        if (env != null && (file = new File(env.getConfig(), "mail.properties")).isFile()) {
            Properties p = new Properties();
            try (FileInputStream in = new FileInputStream(file);){
                p.load(in);
                this.mailer = new Mailer(p);
            }
            catch (Exception e) {
                log.error((Object)"Failed to load mail properties", (Throwable)e);
            }
        }
        if (this.mailer == null) {
            String name = Framework.getProperty((String)"jndi.java.mail", (String)"java:/Mail");
            this.mailer = new Mailer(name);
        }
        return this.mailer;
    }

    public void registerTemplate(URL url) {
        this.urls.put(url.toExternalForm(), url);
    }

    public void unregisterTemplate(URL url) {
        this.urls.remove(url.toExternalForm());
    }

    public void unregisterAllTemplates() {
        this.urls.clear();
    }

    public Mailer getMailer() {
        return this.mailer;
    }

    public FreemarkerEngine getEngine() {
        return this.engine;
    }

    public void render(String template, Object ctx, Writer writer) throws RenderingException {
        this.engine.render(template, ctx, writer);
    }

    public void render(URL template, Object ctx, Writer writer) throws RenderingException {
        String key = template.toExternalForm();
        this.urls.putIfAbsent(key, template);
        this.engine.render(key, ctx, writer);
    }

    public String render(URL template, Object ctx) throws RenderingException {
        String key = template.toExternalForm();
        this.urls.putIfAbsent(key, template);
        StringWriter writer = new StringWriter();
        this.engine.render(key, ctx, (Writer)writer);
        return writer.toString();
    }

    public String render(String templateContent, Object ctx) throws Exception {
        StringReader reader = new StringReader(templateContent);
        Template temp = new Template("@inline", (Reader)reader, this.engine.getConfiguration(), "UTF-8");
        StringWriter writer = new StringWriter();
        freemarker.core.Environment env = temp.createProcessingEnvironment(ctx, (Writer)writer, (ObjectWrapper)this.engine.getObjectWrapper());
        env.process();
        return writer.toString();
    }

    public Mailer.Message newMessage() {
        return this.mailer.newMessage();
    }

    public Mailer.Message newTextMessage(URL template, Object ctx) throws Exception {
        Mailer.Message msg = this.mailer.newMessage();
        msg.setText(this.render(template, ctx), "UTF-8");
        return msg;
    }

    public Mailer.Message newTextMessage(String templateContent, Object ctx) throws Exception {
        Mailer.Message msg = this.mailer.newMessage();
        msg.setText(this.render(templateContent, ctx), "UTF-8");
        return msg;
    }

    public Mailer.Message newHtmlMessage(URL template, Object ctx) throws Exception {
        Mailer.Message msg = this.mailer.newMessage();
        msg.setContent(this.render(template, ctx), "text/html; charset=utf-8");
        return msg;
    }

    public Mailer.Message newHtmlMessage(String templateContent, Object ctx) throws Exception {
        Mailer.Message msg = this.mailer.newMessage();
        msg.setContent(this.render(templateContent, ctx), "text/html; charset=utf-8");
        return msg;
    }

    public Mailer.Message newMixedMessage(String templateContent, Object ctx, String textType, List<Blob> attachments) throws Exception {
        if (textType == null) {
            textType = "plain";
        }
        Mailer.Message msg = this.mailer.newMessage();
        MimeMultipart mp = new MimeMultipart();
        MimeBodyPart body = new MimeBodyPart();
        String result = this.render(templateContent, ctx);
        body.setText(result, "UTF-8", textType);
        mp.addBodyPart((BodyPart)body);
        for (Blob blob : attachments) {
            MimeBodyPart a = new MimeBodyPart();
            a.setDataHandler(new DataHandler((DataSource)new BlobDataSource(blob)));
            a.setFileName(blob.getFilename());
            mp.addBodyPart((BodyPart)a);
        }
        msg.setContent((Multipart)mp);
        return msg;
    }

    public static void main(String[] args) throws Exception {
        Mailer mailer = new Mailer();
        mailer.setServer("smtp.gmail.com", "465", true);
        mailer.setCredentials("xxx", "xxx");
        mailer.setDebug(true);
        Composer c = new Composer(mailer);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key1", "val1");
        Mailer.Message msg = c.newTextMessage("bla ${key1} bla", map).addFrom("bs@nuxeo.com").addTo("bstefanescu@nuxeo.com");
        msg.setSubject("test2");
        msg.send();
    }
}

