/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.hierarchy.permission.factory;

import java.security.Principal;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.impl.DefaultSyncRootFolderItem;
import org.nuxeo.drive.service.FileSystemItemAdapterService;
import org.nuxeo.drive.service.impl.AbstractSyncRootFolderItemFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.api.Framework;

public class PermissionSyncRootFactory
extends AbstractSyncRootFolderItemFactory {
    private static final Log log = LogFactory.getLog(PermissionSyncRootFactory.class);
    protected static final String REQUIRED_PERMISSION_PARAM = "requiredPermission";
    protected static final String USER_SYNC_ROOT_PARENT_FACTORY_PARAM = "userSyncRootParentFactory";
    protected static final String SHARED_SYNC_ROOT_PARENT_FACTORY_PARAM = "sharedSyncRootParentFactory";
    protected String requiredPermission = "ReadWrite";
    protected String userSyncRootParentFactoryName;
    protected String sharedSyncRootParentFactoryName;

    @Override
    public void handleParameters(Map<String, String> parameters) throws ClientException {
        String userSyncRootParentFactoryParam;
        String requiredPermissionParam = parameters.get(REQUIRED_PERMISSION_PARAM);
        if (!StringUtils.isEmpty((String)requiredPermissionParam)) {
            this.requiredPermission = requiredPermissionParam;
        }
        if (StringUtils.isEmpty((String)(userSyncRootParentFactoryParam = parameters.get(USER_SYNC_ROOT_PARENT_FACTORY_PARAM)))) {
            throw new ClientException(String.format("Factory %s has no %s parameter, please provide it in the factory contribution to set the name of the factory for the parent folder of the user's synchronization roots.", this.getName(), USER_SYNC_ROOT_PARENT_FACTORY_PARAM));
        }
        this.userSyncRootParentFactoryName = userSyncRootParentFactoryParam;
        String sharedSyncRootParentFactoryParam = parameters.get(SHARED_SYNC_ROOT_PARENT_FACTORY_PARAM);
        if (StringUtils.isEmpty((String)sharedSyncRootParentFactoryParam)) {
            throw new ClientException(String.format("Factory %s has no %s parameter, please provide it in the factory contribution to set the name of the factory for the parent folder of the user's shared synchronization roots.", this.getName(), SHARED_SYNC_ROOT_PARENT_FACTORY_PARAM));
        }
        this.sharedSyncRootParentFactoryName = sharedSyncRootParentFactoryParam;
    }

    @Override
    public boolean isFileSystemItem(DocumentModel doc, boolean includeDeleted, boolean relaxSyncRootConstraint) throws ClientException {
        CoreSession session = doc.getCoreSession();
        boolean hasRequiredPermission = session.hasPermission(doc.getRef(), this.requiredPermission);
        if (!hasRequiredPermission) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Required permission %s is not granted on document %s to user %s, it cannot be adapted as a FileSystemItem.", this.requiredPermission, doc.getId(), session.getPrincipal().getName()));
            }
            return false;
        }
        return super.isFileSystemItem(doc, includeDeleted, relaxSyncRootConstraint) && hasRequiredPermission;
    }

    @Override
    protected FileSystemItem adaptDocument(DocumentModel doc, boolean forceParentId, FolderItem parentItem, boolean relaxSyncRootConstraint) throws ClientException {
        return new DefaultSyncRootFolderItem(this.name, parentItem, doc, relaxSyncRootConstraint);
    }

    @Override
    protected FolderItem getParentItem(DocumentModel doc) throws ClientException {
        Principal principal = doc.getCoreSession().getPrincipal();
        String docCreator = (String)((Object)doc.getPropertyValue("dc:creator"));
        if (principal.getName().equals(docCreator)) {
            FolderItem parent = this.getFileSystemAdapterService().getVirtualFolderItemFactory(this.userSyncRootParentFactoryName).getVirtualFolderItem(principal);
            if (parent == null) {
                throw new ClientException(String.format("Cannot find the parent of document %s: virtual folder from factory %s.", doc.getId(), this.userSyncRootParentFactoryName));
            }
            return parent;
        }
        FolderItem parent = this.getFileSystemAdapterService().getVirtualFolderItemFactory(this.sharedSyncRootParentFactoryName).getVirtualFolderItem(principal);
        if (parent == null) {
            throw new ClientException(String.format("Cannot find the parent of document %s: virtual folder from factory %s.", doc.getId(), this.sharedSyncRootParentFactoryName));
        }
        return parent;
    }

    protected FileSystemItemAdapterService getFileSystemAdapterService() {
        return (FileSystemItemAdapterService)Framework.getLocalService(FileSystemItemAdapterService.class);
    }
}

