/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import java.security.Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.impl.CollectionSyncRootFolderItem;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.impl.DefaultSyncRootFolderItemFactory;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.api.Framework;

public class CollectionSyncRootFolderItemFactory
extends DefaultSyncRootFolderItemFactory {
    private static final Log log = LogFactory.getLog(CollectionSyncRootFolderItemFactory.class);
    public static final String FACTORY_NAME = "collectionSyncRootFolderItemFactory";

    @Override
    public boolean isFileSystemItem(DocumentModel doc, boolean includeDeleted, boolean relaxSyncRootConstraint) throws ClientException {
        Principal principal;
        NuxeoDriveManager nuxeoDriveManager;
        boolean isSyncRoot;
        if (!((CollectionManager)Framework.getService(CollectionManager.class)).isCollection(doc)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Document %s is not a Collection, it cannot be adapted as a FileSystemItem.", doc.getId()));
            }
            return false;
        }
        if (doc.hasFacet("HiddenInNavigation")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Document %s is HiddenInNavigation, it cannot be adapted as a FileSystemItem.", doc.getId()));
            }
            return false;
        }
        if (!includeDeleted && "deleted".equals(doc.getCurrentLifeCycleState())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Document %s is in the '%s' life cycle state, it cannot be adapted as a FileSystemItem.", doc.getId(), "deleted"));
            }
            return false;
        }
        if (!relaxSyncRootConstraint && !(isSyncRoot = (nuxeoDriveManager = (NuxeoDriveManager)Framework.getLocalService(NuxeoDriveManager.class)).isSynchronizationRoot(principal = doc.getCoreSession().getPrincipal(), doc))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Document %s is not a registered synchronization root for user %s, it cannot be adapted as a FileSystemItem.", doc.getId(), principal.getName()));
            }
            return false;
        }
        return true;
    }

    @Override
    protected FileSystemItem adaptDocument(DocumentModel doc, boolean forceParentItem, FolderItem parentItem, boolean relaxSyncRootConstraint) throws ClientException {
        return new CollectionSyncRootFolderItem(this.name, parentItem, doc, relaxSyncRootConstraint);
    }
}

