/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.impl;

import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.rendition.Rendition;
import org.nuxeo.ecm.platform.rendition.RenditionException;
import org.nuxeo.ecm.platform.rendition.extension.RenditionProvider;
import org.nuxeo.ecm.platform.rendition.impl.LazyRendition;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;

public class LiveRendition
extends LazyRendition
implements Rendition {
    protected final DocumentModel doc;

    public LiveRendition(DocumentModel doc, RenditionDefinition definition) {
        super(definition);
        this.doc = doc;
    }

    @Override
    public boolean isStored() {
        return false;
    }

    @Override
    public DocumentModel getHostDocument() {
        return this.doc;
    }

    @Override
    protected List<Blob> computeRenditionBlobs() throws RenditionException {
        RenditionProvider provider = this.getDefinition().getProvider();
        if (provider == null) {
            throw new RenditionException("No Rendition provider defined");
        }
        return provider.render(this.getHostDocument(), this.getDefinition());
    }
}

