/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ECSSVersion;
import com.phloc.css.ICSSVersionAware;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSDeclaration;
import com.phloc.css.decl.CSSDeclarationContainer;
import com.phloc.css.decl.ICSSTopLevelRule;
import com.phloc.css.decl.IHasCSSDeclarations;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CSSPageRule
implements ICSSTopLevelRule,
IHasCSSDeclarations,
ICSSVersionAware {
    private final String m_sPseudoPage;
    private final CSSDeclarationContainer m_aDeclarations = new CSSDeclarationContainer();

    public CSSPageRule(@Nullable String string) {
        this.m_sPseudoPage = string;
    }

    @Nullable
    public String getPseudoPage() {
        return this.m_sPseudoPage;
    }

    @Override
    public void addDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        this.m_aDeclarations.addDeclaration(cSSDeclaration);
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        return this.m_aDeclarations.removeDeclaration(cSSDeclaration);
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnegative int n) {
        return this.m_aDeclarations.removeDeclaration(n);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<CSSDeclaration> getAllDeclarations() {
        return this.m_aDeclarations.getAllDeclarations();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationAtIndex(@Nonnegative int n) {
        return this.m_aDeclarations.getDeclarationAtIndex(n);
    }

    @Override
    public boolean hasDeclarations() {
        return this.m_aDeclarations.hasDeclarations();
    }

    @Override
    @Nonnegative
    public int getDeclarationCount() {
        return this.m_aDeclarations.getDeclarationCount();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        if (!iCSSWriterSettings.isWritePageRules()) {
            return "";
        }
        if (iCSSWriterSettings.isRemoveUnnecessaryCode() && this.getDeclarationCount() == 0) {
            return "";
        }
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        StringBuilder stringBuilder = new StringBuilder("@page");
        if (StringHelper.hasText((CharSequence)this.m_sPseudoPage)) {
            stringBuilder.append(' ').append(this.m_sPseudoPage);
        }
        stringBuilder.append(this.m_aDeclarations.getAsCSSString(iCSSWriterSettings, n));
        if (!bl) {
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS21;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CSSPageRule)) {
            return false;
        }
        CSSPageRule cSSPageRule = (CSSPageRule)object;
        return this.m_aDeclarations.equals(cSSPageRule.m_aDeclarations);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aDeclarations).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("declarations", (Object)this.m_aDeclarations).toString();
    }
}

