/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.decl.CSSFontFaceRule;
import com.phloc.css.decl.CSSImportRule;
import com.phloc.css.decl.CSSKeyframesRule;
import com.phloc.css.decl.CSSMediaRule;
import com.phloc.css.decl.CSSNamespaceRule;
import com.phloc.css.decl.CSSPageRule;
import com.phloc.css.decl.CSSStyleRule;
import com.phloc.css.decl.CSSViewportRule;
import com.phloc.css.decl.ICSSTopLevelRule;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CascadingStyleSheet {
    private final List<CSSImportRule> m_aImportRules = new ArrayList<CSSImportRule>();
    private final List<CSSNamespaceRule> m_aNamespaceRules = new ArrayList<CSSNamespaceRule>();
    private final List<ICSSTopLevelRule> m_aRules = new ArrayList<ICSSTopLevelRule>();

    public boolean hasImportRules() {
        return !this.m_aImportRules.isEmpty();
    }

    @Nonnegative
    public int getImportRuleCount() {
        return this.m_aImportRules.size();
    }

    public void addImportRule(@Nonnull CSSImportRule cSSImportRule) {
        if (cSSImportRule == null) {
            throw new NullPointerException("ImportRule");
        }
        this.m_aImportRules.add(cSSImportRule);
    }

    public void addImportRule(@Nonnegative int n, @Nonnull CSSImportRule cSSImportRule) {
        if (cSSImportRule == null) {
            throw new NullPointerException("ImportRule");
        }
        this.m_aImportRules.add(n, cSSImportRule);
    }

    @Nonnull
    public EChange removeImportRule(@Nullable CSSImportRule cSSImportRule) {
        return EChange.valueOf((boolean)this.m_aImportRules.remove(cSSImportRule));
    }

    @Nonnull
    public EChange removeImportRule(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aImportRules.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aImportRules.remove(n);
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSImportRule> getAllImportRules() {
        return ContainerHelper.newList(this.m_aImportRules);
    }

    public boolean hasNamespaceRules() {
        return !this.m_aNamespaceRules.isEmpty();
    }

    @Nonnegative
    public int getNamespaceRuleCount() {
        return this.m_aNamespaceRules.size();
    }

    public void addNamespaceRule(@Nonnull CSSNamespaceRule cSSNamespaceRule) {
        if (cSSNamespaceRule == null) {
            throw new NullPointerException("NamespaceRule");
        }
        this.m_aNamespaceRules.add(cSSNamespaceRule);
    }

    public void addNamespaceRule(@Nonnegative int n, @Nonnull CSSNamespaceRule cSSNamespaceRule) {
        if (cSSNamespaceRule == null) {
            throw new NullPointerException("NamespaceRule");
        }
        this.m_aNamespaceRules.add(n, cSSNamespaceRule);
    }

    @Nonnull
    public EChange removeNamespaceRule(@Nullable CSSNamespaceRule cSSNamespaceRule) {
        return EChange.valueOf((boolean)this.m_aNamespaceRules.remove(cSSNamespaceRule));
    }

    @Nonnull
    public EChange removeNamespaceRule(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aNamespaceRules.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aNamespaceRules.remove(n);
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSNamespaceRule> getAllNamespaceRules() {
        return ContainerHelper.newList(this.m_aNamespaceRules);
    }

    public boolean hasRules() {
        return !this.m_aRules.isEmpty();
    }

    @Nonnegative
    public int getRuleCount() {
        return this.m_aRules.size();
    }

    public void addRule(@Nonnull ICSSTopLevelRule iCSSTopLevelRule) {
        if (iCSSTopLevelRule == null) {
            throw new NullPointerException("styleRule");
        }
        this.m_aRules.add(iCSSTopLevelRule);
    }

    public void addRule(@Nonnegative int n, @Nonnull ICSSTopLevelRule iCSSTopLevelRule) {
        if (iCSSTopLevelRule == null) {
            throw new NullPointerException("styleRule");
        }
        this.m_aRules.add(n, iCSSTopLevelRule);
    }

    @Nonnull
    public EChange removeRule(@Nullable ICSSTopLevelRule iCSSTopLevelRule) {
        return EChange.valueOf((boolean)this.m_aRules.remove(iCSSTopLevelRule));
    }

    @Nonnull
    public EChange removeRule(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aRules.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aRules.remove(n);
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ICSSTopLevelRule> getAllRules() {
        return ContainerHelper.newList(this.m_aRules);
    }

    public boolean hasStyleRules() {
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSStyleRule)) continue;
            return true;
        }
        return false;
    }

    @Nonnegative
    public int getStyleRuleCount() {
        int n = 0;
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSStyleRule)) continue;
            ++n;
        }
        return n;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSStyleRule> getAllStyleRules() {
        ArrayList<CSSStyleRule> arrayList = new ArrayList<CSSStyleRule>();
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSStyleRule)) continue;
            arrayList.add((CSSStyleRule)iCSSTopLevelRule);
        }
        return arrayList;
    }

    public boolean hasPageRules() {
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSPageRule)) continue;
            return true;
        }
        return false;
    }

    @Nonnegative
    public int getPageRuleCount() {
        int n = 0;
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSPageRule)) continue;
            ++n;
        }
        return n;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSPageRule> getAllPageRules() {
        ArrayList<CSSPageRule> arrayList = new ArrayList<CSSPageRule>();
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSPageRule)) continue;
            arrayList.add((CSSPageRule)iCSSTopLevelRule);
        }
        return arrayList;
    }

    public boolean hasMediaRules() {
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSMediaRule)) continue;
            return true;
        }
        return false;
    }

    @Nonnegative
    public int getMediaRuleCount() {
        int n = 0;
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSMediaRule)) continue;
            ++n;
        }
        return n;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSMediaRule> getAllMediaRules() {
        ArrayList<CSSMediaRule> arrayList = new ArrayList<CSSMediaRule>();
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSMediaRule)) continue;
            arrayList.add((CSSMediaRule)iCSSTopLevelRule);
        }
        return arrayList;
    }

    public boolean hasFontFaceRules() {
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSFontFaceRule)) continue;
            return true;
        }
        return false;
    }

    @Nonnegative
    public int getFontFaceRuleCount() {
        int n = 0;
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSFontFaceRule)) continue;
            ++n;
        }
        return n;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSFontFaceRule> getAllFontFaceRules() {
        ArrayList<CSSFontFaceRule> arrayList = new ArrayList<CSSFontFaceRule>();
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSFontFaceRule)) continue;
            arrayList.add((CSSFontFaceRule)iCSSTopLevelRule);
        }
        return arrayList;
    }

    public boolean hasKeyframesRules() {
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSKeyframesRule)) continue;
            return true;
        }
        return false;
    }

    @Nonnegative
    public int getKeyframesRuleCount() {
        int n = 0;
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSKeyframesRule)) continue;
            ++n;
        }
        return n;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSKeyframesRule> getAllKeyframesRules() {
        ArrayList<CSSKeyframesRule> arrayList = new ArrayList<CSSKeyframesRule>();
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSKeyframesRule)) continue;
            arrayList.add((CSSKeyframesRule)iCSSTopLevelRule);
        }
        return arrayList;
    }

    public boolean hasViewportRules() {
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSViewportRule)) continue;
            return true;
        }
        return false;
    }

    @Nonnegative
    public int getViewportRuleCount() {
        int n = 0;
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSViewportRule)) continue;
            ++n;
        }
        return n;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSViewportRule> getAllViewportRules() {
        ArrayList<CSSViewportRule> arrayList = new ArrayList<CSSViewportRule>();
        for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
            if (!(iCSSTopLevelRule instanceof CSSViewportRule)) continue;
            arrayList.add((CSSViewportRule)iCSSTopLevelRule);
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CascadingStyleSheet)) {
            return false;
        }
        CascadingStyleSheet cascadingStyleSheet = (CascadingStyleSheet)object;
        return ((Object)this.m_aImportRules).equals(cascadingStyleSheet.m_aImportRules) && ((Object)this.m_aNamespaceRules).equals(cascadingStyleSheet.m_aNamespaceRules) && ((Object)this.m_aRules).equals(cascadingStyleSheet.m_aRules);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aImportRules).append(this.m_aNamespaceRules).append(this.m_aRules).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("importRules", this.m_aImportRules).append("namespaceRules", this.m_aNamespaceRules).append("rules", this.m_aRules).toString();
    }
}

