/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.handler;

import com.phloc.css.ECSSVersion;
import com.phloc.css.decl.CSSDeclarationList;
import com.phloc.css.decl.CascadingStyleSheet;
import com.phloc.css.handler.CSSNodeToDomainObject;
import com.phloc.css.handler.ECSSNodeType;
import com.phloc.css.parser.CSSNode;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSHandler {
    private CSSHandler() {
    }

    @Nonnull
    public static CascadingStyleSheet readCascadingStyleSheetFromNode(@Nonnull ECSSVersion eCSSVersion, @Nonnull CSSNode cSSNode) {
        if (eCSSVersion == null) {
            throw new NullPointerException("version");
        }
        if (cSSNode == null) {
            throw new NullPointerException("node");
        }
        if (!ECSSNodeType.ROOT.isNode(cSSNode, eCSSVersion)) {
            throw new IllegalArgumentException("Passed node is not a root node!");
        }
        return new CSSNodeToDomainObject(eCSSVersion).createCascadingStyleSheetFromNode(cSSNode);
    }

    @Nonnull
    public static CSSDeclarationList readDeclarationListFromNode(@Nonnull ECSSVersion eCSSVersion, @Nonnull CSSNode cSSNode) {
        if (eCSSVersion == null) {
            throw new NullPointerException("version");
        }
        if (cSSNode == null) {
            throw new NullPointerException("node");
        }
        if (!ECSSNodeType.STYLEDECLARATION.isNode(cSSNode, eCSSVersion)) {
            throw new IllegalArgumentException("Passed node is not a style declaration node!");
        }
        return new CSSNodeToDomainObject(eCSSVersion).createDeclarationListFromNode(cSSNode);
    }
}

