/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmd.TerminationException;
import arq.cmdline.ArgDecl;
import arq.cmdline.ArgModuleGeneral;
import arq.cmdline.CmdArgModule;
import arq.cmdline.CmdGeneral;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.shared.NotFoundException;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.resultset.ResultSetFormat;

public class ModResultsIn
implements ArgModuleGeneral {
    protected final ArgDecl resultsInputFmtDecl = new ArgDecl(true, "in");
    protected final ArgDecl fileDecl = new ArgDecl(true, "file");
    private ResultSetFormat inputFormat = ResultSetFormat.syntaxText;
    private String resultsFilename = null;
    private ResultSet resultSet = null;

    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.getUsage().startCategory("Results");
        cmdLine.add(this.fileDecl, "--file", "Input file");
        cmdLine.add(this.resultsInputFmtDecl, "--in", "Results format (XML, JSON; RDF serialization)");
    }

    public void processArgs(CmdArgModule cmdline) throws IllegalArgumentException {
        if (cmdline.contains(this.fileDecl)) {
            this.resultsFilename = cmdline.getValue(this.fileDecl);
        }
        if (cmdline.getNumPositional() == 0 && this.resultsFilename == null) {
            cmdline.cmdError("No results file");
        }
        if (cmdline.getNumPositional() > 1) {
            cmdline.cmdError("Only one result set file allowed");
        }
        if (cmdline.getNumPositional() == 1 && this.resultsFilename != null) {
            cmdline.cmdError("Either result set file or --file - not both");
        }
        if (this.resultsFilename == null) {
            this.resultsFilename = cmdline.getPositionalArg(0);
        }
        if (this.resultsFilename != null) {
            this.inputFormat = ResultSetFormat.guessSyntax(this.resultsFilename);
        }
        if (cmdline.contains(this.resultsInputFmtDecl)) {
            String rFmt = cmdline.getValue(this.resultsInputFmtDecl);
            this.inputFormat = ResultSetFormat.lookup(rFmt);
            if (this.inputFormat == null) {
                cmdline.cmdError("Unrecognized output format: " + rFmt);
            }
        }
    }

    public void checkCommandLine(CmdArgModule cmdLine) {
    }

    public ResultSet getResultSet() {
        if (this.resultSet != null) {
            return this.resultSet;
        }
        if (this.resultsFilename == null) {
            System.err.println("No result file name");
            throw new TerminationException(1);
        }
        try {
            if (this.resultsFilename.equals("-")) {
                return ResultSetFactory.load(System.in, this.inputFormat);
            }
            ResultSet rs = ResultSetFactory.load(this.resultsFilename, this.inputFormat);
            if (rs == null) {
                System.err.println("Failed to read the result set");
                throw new TerminationException(9);
            }
            this.resultSet = rs;
            return this.resultSet;
        }
        catch (NotFoundException ex) {
            System.err.println("File not found: " + this.resultsFilename);
            throw new TerminationException(9);
        }
        catch (ARQInternalErrorException intEx) {
            System.err.println(intEx.getMessage());
            if (intEx.getCause() != null) {
                System.err.println("Cause:");
                intEx.getCause().printStackTrace(System.err);
                System.err.println();
            }
            intEx.printStackTrace(System.err);
            throw new TerminationException(99);
        }
    }

    public ResultSetFormat getInputFormat() {
        return this.inputFormat;
    }
}

