/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.commandline.executor.service;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="environment")
public class EnvironmentDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XNode(value="workingDirectory")
    protected String workingDirectory;
    @XNodeMap(value="parameters/parameter", key="@name", type=HashMap.class, componentType=String.class)
    protected Map<String, String> parameters = new HashMap<String, String>();

    public String getWorkingDirectory() {
        if (this.workingDirectory == null) {
            this.workingDirectory = System.getProperty("java.io.tmpdir");
        }
        if (!this.workingDirectory.endsWith("/")) {
            this.workingDirectory = this.workingDirectory + "/";
        }
        return this.workingDirectory;
    }

    public void merge(EnvironmentDescriptor other) {
        if (other.workingDirectory != null) {
            this.workingDirectory = other.workingDirectory;
        }
        this.parameters.putAll(other.parameters);
    }
}

