/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types;

import java.util.ArrayList;
import org.nuxeo.ecm.core.schema.TypeProvider;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.TypeException;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractType
implements Type {
    private static final long serialVersionUID = 1L;
    public static final Type[] EMPTY_SUPERTYPES = new Type[0];
    protected final String name;
    protected final String schema;
    protected final Type superType;

    protected AbstractType(Type superType, String schema, String name) {
        this.name = name;
        this.schema = schema;
        this.superType = superType;
    }

    @Override
    public Type getSuperType() {
        return this.superType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSchemaName() {
        return this.schema;
    }

    @Override
    public Schema getSchema() {
        return ((TypeProvider)Framework.getLocalService(TypeProvider.class)).getSchema(this.schema);
    }

    @Override
    public boolean isSuperTypeOf(Type type) {
        Type t = type;
        do {
            if (this != t) continue;
            return true;
        } while ((t = t.getSuperType()) != null);
        return false;
    }

    public boolean isAny() {
        return false;
    }

    @Override
    public Type[] getTypeHierarchy() {
        Type type = this.getSuperType();
        if (type == null) {
            return EMPTY_SUPERTYPES;
        }
        ArrayList<Type> types = new ArrayList<Type>();
        while (type != null) {
            types.add(type);
            type = type.getSuperType();
        }
        return types.toArray(new Type[types.size()]);
    }

    @Override
    public boolean isSimpleType() {
        return false;
    }

    @Override
    public boolean isComplexType() {
        return false;
    }

    @Override
    public boolean isListType() {
        return false;
    }

    @Override
    public boolean isAnyType() {
        return false;
    }

    @Override
    public boolean isCompositeType() {
        return false;
    }

    @Override
    public boolean validate(Object object) throws TypeException {
        return true;
    }

    @Override
    public Object decode(String string) {
        return null;
    }

    @Override
    public String encode(Object object) {
        return null;
    }

    @Override
    public Object newInstance() {
        return null;
    }
}

