/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types.primitives;

import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.schema.types.PrimitiveType;

public final class DoubleType
extends PrimitiveType {
    private static final long serialVersionUID = 1L;
    public static final String ID = "double";
    public static final DoubleType INSTANCE = new DoubleType();

    private DoubleType() {
        super(ID);
    }

    @Override
    public boolean validate(Object object) {
        return object instanceof Number;
    }

    @Override
    public Object convert(Object value) {
        if (value instanceof Double) {
            return value;
        }
        if (value instanceof Number) {
            return (double)((Number)value).longValue();
        }
        try {
            return Double.valueOf((String)value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public Object decode(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        try {
            return Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    @Override
    public String encode(Object object) {
        if (object instanceof Double) {
            return object.toString();
        }
        if (object instanceof Number) {
            return object.toString();
        }
        return object != null ? (String)object : "";
    }

    protected Object readResolve() {
        return INSTANCE;
    }
}

