/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.api;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteElement;
import org.nuxeo.ecm.platform.routing.api.RouteFolderElement;
import org.nuxeo.ecm.platform.routing.api.RouteTable;

public class DocumentRouteTableElement {
    protected final DocumentRouteElement element;
    protected final RouteTable table;
    protected final int depth;
    protected RouteFolderElement parent;
    protected boolean isFirstChild;
    protected List<RouteFolderElement> firstChildList = new ArrayList<RouteFolderElement>();

    public DocumentRouteTableElement(DocumentRouteElement element, RouteTable table, int depth, RouteFolderElement parent, boolean isFirstChild) {
        this.table = table;
        this.depth = depth;
        this.element = element;
        this.parent = parent;
        this.isFirstChild = isFirstChild;
    }

    public RouteFolderElement getParent() {
        return this.parent;
    }

    public DocumentRouteElement getElement() {
        return this.element;
    }

    public int getDepth() {
        return this.depth;
    }

    public RouteTable getRouteTable() {
        return this.table;
    }

    public List<RouteFolderElement> getFirstChildFolders() {
        return this.firstChildList;
    }

    public int getRouteMaxDepth() {
        return this.table.getMaxDepth();
    }

    public DocumentModel getDocument() {
        return this.element.getDocument();
    }

    public void computeFirstChildList() {
        RouteFolderElement currentParent = this.parent;
        boolean currentIsFirst = this.isFirstChild;
        while (currentIsFirst && currentParent != null) {
            currentIsFirst = currentParent.isFirstChild;
            this.firstChildList.add(0, currentParent);
            currentParent = currentParent.parent;
        }
    }
}

