/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.jdbc.logging;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.javasimon.Callback;
import org.javasimon.CallbackSkeleton;
import org.javasimon.Split;
import org.javasimon.jdbc.logging.CallbackLogParams;
import org.javasimon.jdbc.logging.SimonFormatter;
import org.javasimon.utils.SimonUtils;

public final class LoggingCallback
extends CallbackSkeleton {
    private String prefix;
    private String logFilename;
    private String loggerName;
    private boolean logToConsole;
    private String logFormat;
    private Logger logger;

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setLogFilename(String logFilename) {
        this.logFilename = logFilename;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public void setLogToConsole() {
        this.logToConsole = true;
    }

    public void setLogFormat(String logFormat) {
        this.logFormat = logFormat;
    }

    public void initialize() {
        SimonFormatter f;
        this.logger = Logger.getLogger(this.loggerName != null && this.loggerName.length() > 0 ? this.loggerName : "simon_jdbc_logger");
        if (this.logFilename != null && this.logFilename.length() > 0) {
            this.logger.setUseParentHandlers(false);
            try {
                FileHandler fh = new FileHandler(this.logFilename, true);
                f = this.formatter();
                if (f != null) {
                    fh.setFormatter(f);
                }
                this.logger.addHandler(fh);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.logToConsole) {
            ConsoleHandler ch = new ConsoleHandler();
            f = this.formatter();
            if (f != null) {
                ch.setFormatter(f);
            }
            this.logger.addHandler(ch);
        }
    }

    private SimonFormatter formatter() {
        if (this.logFormat != null) {
            if (this.logFormat.equalsIgnoreCase("human")) {
                return new HumanFormatter();
            }
            if (this.logFormat.equalsIgnoreCase("csv")) {
                return new CsvFormatter();
            }
            try {
                Object o = Class.forName(this.logFormat).newInstance();
                if (o instanceof SimonFormatter) {
                    return (SimonFormatter)o;
                }
            }
            catch (Exception e) {
                return new HumanFormatter();
            }
        }
        return new HumanFormatter();
    }

    public void stopwatchStart(Split split) {
        String localName;
        String fullName = split.getStopwatch().getName();
        if (fullName != null && fullName.startsWith(this.prefix) && ((localName = SimonUtils.localName((String)fullName)).equals("conn") || localName.equals("stmt"))) {
            this.logger.log(Level.INFO, "Start: {0}", new CallbackLogParams(fullName, Callback.Event.STOPWATCH_START, 0L, split.getStopwatch().getNote()));
        }
    }

    public void stopwatchStop(Split split) {
        String fullName = split.getStopwatch().getName();
        if (fullName != null && fullName.startsWith(this.prefix)) {
            this.logger.log(Level.INFO, "Stop: {0}", new CallbackLogParams(fullName, Callback.Event.STOPWATCH_STOP, split.runningFor(), split.getStopwatch().getNote()));
        }
    }

    private static final class CsvFormatter
    extends SimonFormatter {
        private static final String ID = "csv";
        private final String lineSeparator = System.getProperty("line.separator");

        private CsvFormatter() {
        }

        protected String formatRecord(LogRecord record, CallbackLogParams params) {
            StringBuilder sb = new StringBuilder();
            sb.append(record.getMillis()).append('|');
            sb.append(record.getThreadID()).append('|');
            String ln = params.getLocalName();
            sb.append(ln.equals("conn") || ln.equals("stmt") ? ln : "sql").append(this.isStart(params) ? "|>" : "|<").append('|');
            sb.append(params.getFullName()).append('|');
            sb.append(params.getSplit()).append('|');
            sb.append(params.getNote()).append(this.lineSeparator);
            return sb.toString();
        }
    }

    private static final class HumanFormatter
    extends SimonFormatter {
        private static final String ID = "human";
        private final Date dat = new Date();
        private final SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSS");
        private final String lineSeparator = System.getProperty("line.separator");

        private HumanFormatter() {
        }

        protected String formatRecord(LogRecord record, CallbackLogParams params) {
            this.dat.setTime(record.getMillis());
            StringBuilder sb = new StringBuilder();
            sb.append(this.dateTimeFormat.format(this.dat)).append(' ');
            sb.append(record.getThreadID()).append(' ');
            String ln = params.getLocalName();
            sb.append('[').append(ln.equals("conn") || ln.equals("stmt") ? ln : "sql ").append(this.isStart(params) ? "->" : "-<").append("]").append(' ');
            sb.append(params.getFullName()).append(' ');
            sb.append(SimonUtils.presentNanoTime((long)params.getSplit())).append(' ');
            sb.append(this.note(params)).append(this.lineSeparator);
            return sb.toString();
        }
    }
}

