/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.computedgroups;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.computedgroups.AbstractGroupComputer;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.runtime.api.Framework;

public class DocumentMetadataGroupComputer
extends AbstractGroupComputer {
    public static final Log log = LogFactory.getLog(DocumentMetadataGroupComputer.class);
    private String groupPattern;
    private String whereClause;
    private String xpath;

    public DocumentMetadataGroupComputer(String whereClause, String groupPattern, String xpath) throws ClientException {
        this.whereClause = whereClause;
        this.xpath = xpath;
        this.groupPattern = groupPattern;
        if (whereClause == null || whereClause.isEmpty() || groupPattern == null || groupPattern.isEmpty()) {
            throw new ClientException("Bad Contribution Document Metadata Computer Group Configuration");
        }
    }

    @Override
    public List<String> getAllGroupIds() throws Exception {
        ArrayList<String> groupIds = new ArrayList<String>();
        return groupIds;
    }

    @Override
    public List<String> getGroupMembers(String groupId) throws Exception {
        ArrayList<String> participants = new ArrayList<String>();
        return participants;
    }

    @Override
    public List<String> getGroupsForUser(NuxeoPrincipalImpl user) throws Exception {
        String username = user.getName();
        GetDocumentsFromUsername runner = new GetDocumentsFromUsername(this.getRepository(), this.whereClause, username, this.xpath);
        runner.runUnrestricted();
        ArrayList<String> groupIds = new ArrayList<String>();
        String groupId = null;
        for (String value : runner.result) {
            groupId = this.getGroupIdFromValue(value);
            log.debug((Object)("Virtual Group Id found: " + groupId));
            groupIds.add(groupId);
        }
        return groupIds;
    }

    @Override
    public List<String> getParentsGroupNames(String groupID) throws Exception {
        return new ArrayList<String>();
    }

    @Override
    public List<String> getSubGroupsNames(String groupID) throws Exception {
        return new ArrayList<String>();
    }

    @Override
    public boolean hasGroup(String groupId) throws Exception {
        return false;
    }

    private String getRepository() {
        RepositoryManager mgr = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
        return mgr.getDefaultRepositoryName();
    }

    private String getGroupIdFromValue(String value) {
        return String.format(this.groupPattern, value);
    }

    protected class GetDocumentsFromUsername
    extends UnrestrictedSessionRunner {
        private static final String QUERY_PATTERN = "SELECT %s FROM Document %s";
        protected String username;
        protected String xpath;
        protected String whereClausePattern;
        public List<String> result;

        protected GetDocumentsFromUsername(String repositoryName, String whereClause, String username, String xpath) throws Exception {
            super(repositoryName);
            this.result = new ArrayList<String>();
            this.username = username;
            this.whereClausePattern = whereClause;
            this.xpath = xpath;
        }

        public void run() throws ClientException {
            String whereClause = String.format(this.whereClausePattern, this.username);
            String query = String.format(QUERY_PATTERN, this.xpath, whereClause);
            IterableQueryResult docs = this.session.queryAndFetch(query, "NXQL", new Object[0]);
            for (Map doc : docs) {
                String value = (String)doc.get(this.xpath);
                if (value == null || value.isEmpty() || this.result.contains(value)) continue;
                this.result.add(value);
            }
        }
    }
}

