/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.usermanager.UserManagerDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.login.Authenticator;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.services.event.EventListener;
import org.nuxeo.runtime.services.event.EventService;

public class UserService
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName(UserService.class.getName());
    private static final Log log = LogFactory.getLog(UserService.class);
    private final List<UserManagerDescriptor> descriptors = new LinkedList<UserManagerDescriptor>();
    private UserManager userManager;

    public UserManager getUserManager() throws ClientException {
        if (this.userManager == null) {
            this.recomputeUserManager(false);
            EventService eventService = (EventService)Framework.getLocalService(EventService.class);
            eventService.addListener("usermanager", (EventListener)this.userManager);
        }
        return this.userManager;
    }

    protected void recomputeUserManager(boolean lazy) throws ClientException {
        if (lazy && this.userManager == null) {
            return;
        }
        UserManagerDescriptor merged = new UserManagerDescriptor();
        merged.userListingMode = "search_only";
        merged.userDirectoryName = "userDirectory";
        merged.userEmailField = "email";
        merged.userSearchFields = new HashMap();
        merged.userSearchFields.put("username", UserManager.MatchType.SUBSTRING);
        merged.userSearchFields.put("firstName", UserManager.MatchType.SUBSTRING);
        merged.userSearchFields.put("lastName", UserManager.MatchType.SUBSTRING);
        merged.groupDirectoryName = "groupDirectory";
        merged.groupLabelField = "grouplabel";
        merged.groupMembersField = "members";
        merged.groupSubGroupsField = "subGroups";
        merged.groupParentGroupsField = "parentGroups";
        merged.groupSearchFields = new HashMap();
        merged.groupSearchFields.put("groupname", UserManager.MatchType.SUBSTRING);
        merged.groupSearchFields.put("grouplabel", UserManager.MatchType.SUBSTRING);
        for (UserManagerDescriptor descriptor : this.descriptors) {
            merged.merge(descriptor);
        }
        Class klass = merged.userManagerClass;
        if (this.userManager == null) {
            if (this.descriptors.isEmpty()) {
                throw new ClientException("No contributions registered for the userManager");
            }
            if (klass == null) {
                throw new ClientException("No class specified for the userManager");
            }
        }
        if (klass != null) {
            try {
                this.userManager = (UserManager)klass.newInstance();
            }
            catch (InstantiationException e) {
                throw new ClientException("Failed to instantiate class " + klass, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ClientException("Failed to instantiate class " + klass, (Throwable)e);
            }
        }
        this.userManager.setConfiguration(merged);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (Authenticator.class == adapter || UserManager.class == adapter) {
            try {
                return adapter.cast(this.getUserManager());
            }
            catch (ClientException e) {
                log.error((Object)("Error fetching UserManager: " + e.getMessage()), (Throwable)e);
            }
        }
        return null;
    }

    public void activate(ComponentContext context) {
        log.info((Object)"UserService activated");
    }

    public void deactivate(ComponentContext context) {
        EventService eventService;
        log.info((Object)"UserService deactivated");
        if (this.userManager != null && (eventService = (EventService)Framework.getLocalService(EventService.class)) != null) {
            eventService.removeListener("usermanager", (EventListener)this.userManager);
        }
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws ClientException {
        this.descriptors.add((UserManagerDescriptor)contribution);
        this.recomputeUserManager(true);
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws ClientException {
        this.descriptors.remove(contribution);
    }
}

