/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoRepository;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class NuxeoRepositories
extends DefaultComponent {
    protected Map<String, NuxeoRepository> repositories;

    public void activate(ComponentContext context) throws Exception {
        this.repositories = new ConcurrentHashMap<String, NuxeoRepository>();
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.repositories = null;
    }

    public NuxeoRepository getRepository(String repositoryId) {
        this.initRepositories();
        return this.repositories.get(repositoryId);
    }

    public List<NuxeoRepository> getRepositories() {
        this.initRepositories();
        return new ArrayList<NuxeoRepository>(this.repositories.values());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initRepositories() {
        if (!this.repositories.isEmpty()) {
            return;
        }
        try {
            RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
            for (String repositoryName : repositoryManager.getRepositoryNames()) {
                try {
                    CoreSession coreSession = CoreInstance.openCoreSession((String)repositoryName);
                    Throwable throwable = null;
                    try {
                        String rootFolderId = coreSession.getRootDocument().getId();
                        this.repositories.put(repositoryName, new NuxeoRepository(repositoryName, rootFolderId));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (coreSession == null) continue;
                        if (throwable != null) {
                            try {
                                coreSession.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        coreSession.close();
                    }
                }
                catch (ClientException e) {
                    throw new CmisRuntimeException(e.toString(), (Throwable)e);
                    return;
                }
            }
        }
        catch (CmisRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }
}

