/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.remoting.marshaling;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.impl.DocumentPipeImpl;
import org.nuxeo.ecm.core.io.impl.plugins.XMLDocumentWriter;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.ExtendedDocumentLocation;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.interfaces.DocumentModelMarshaler;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.interfaces.PublishingMarshalingException;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.io.SingleDocumentReaderWithInLineBlobs;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.io.SingleShadowDocumentWriter;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.io.SingleXMlDocumentReader;

public class CoreIODocumentModelMarshaler
implements DocumentModelMarshaler {
    protected String originatingServer;

    public String marshalDocument(DocumentModel doc) throws PublishingMarshalingException {
        if (this.originatingServer != null) {
            String source = new ExtendedDocumentLocation(this.originatingServer, doc).toString();
            try {
                doc.setProperty("dublincore", "source", (Object)source);
            }
            catch (ClientException e) {
                throw new PublishingMarshalingException((Throwable)e);
            }
        }
        CoreSession coreSession = doc.getCoreSession();
        SingleDocumentReaderWithInLineBlobs reader = new SingleDocumentReaderWithInLineBlobs(coreSession, doc);
        File tmpFile = null;
        try {
            String line;
            tmpFile = File.createTempFile("io-marshaling-", "xml");
            XMLDocumentWriter writer = new XMLDocumentWriter(tmpFile);
            DocumentPipeImpl pipe = new DocumentPipeImpl();
            pipe.setReader((DocumentReader)reader);
            pipe.setWriter((DocumentWriter)writer);
            pipe.run();
            FileReader freader = new FileReader(tmpFile);
            BufferedReader br = new BufferedReader(freader);
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            reader.close();
            br.close();
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            throw new PublishingMarshalingException("Unable to marshal DocumentModel", (Throwable)e);
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    public DocumentModel unMarshalDocument(String data, CoreSession coreSession) throws PublishingMarshalingException {
        try {
            SingleXMlDocumentReader reader = new SingleXMlDocumentReader(data);
            SingleShadowDocumentWriter writer = new SingleShadowDocumentWriter(coreSession, null);
            DocumentPipeImpl pipe = new DocumentPipeImpl();
            pipe.setReader((DocumentReader)reader);
            pipe.setWriter((DocumentWriter)writer);
            pipe.run();
            return writer.getShadowDocument();
        }
        catch (Exception e) {
            throw new PublishingMarshalingException("Unable to unmarshal DocumentModel", (Throwable)e);
        }
    }

    public void setOriginatingServer(String serverName) {
        this.originatingServer = serverName;
    }
}

