/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.seam;

import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MXBean;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NuxeoSeamWebGate
implements ServletContextListener {
    protected static NuxeoSeamWebGate instance;
    protected static Log log;
    protected boolean initialized;
    protected final Set<WebConnector> waitingConnectors = this.fetchConnectors();

    public NuxeoSeamWebGate() {
        instance = this;
    }

    public void contextDestroyed(ServletContextEvent arg0) {
        this.initialized = false;
    }

    public void contextInitialized(ServletContextEvent arg0) {
        this.initialized = true;
    }

    protected Set<WebConnector> fetchConnectors() {
        ObjectName names;
        HashSet<WebConnector> connectors = new HashSet<WebConnector>();
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            names = new ObjectName("Catalina:type=Connector,port=*,address=*");
        }
        catch (MalformedObjectNameException e) {
            log.error((Object)"Cannot query for tomcat connectors", (Throwable)e);
            return connectors;
        }
        Set<ObjectInstance> ois = mbs.queryMBeans(names, null);
        for (ObjectInstance oi : ois) {
            WebConnector connector = JMX.newMBeanProxy(mbs, oi.getObjectName(), WebConnector.class);
            connectors.add(connector);
        }
        return connectors;
    }

    protected synchronized boolean checkConnectorsUp() {
        Iterator<WebConnector> it = this.waitingConnectors.iterator();
        while (it.hasNext()) {
            WebConnector connector = it.next();
            if (!"STARTED".equals(connector.getStateName())) continue;
            it.remove();
        }
        return this.waitingConnectors.isEmpty();
    }

    public static boolean isInitialized() {
        if (instance == null) {
            return false;
        }
        if (!NuxeoSeamWebGate.instance.initialized) {
            return false;
        }
        return instance.checkConnectorsUp();
    }

    static {
        log = LogFactory.getLog(NuxeoSeamWebGate.class);
    }

    @MXBean
    public static interface WebConnector {
        public String getStateName();
    }
}

