/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine;

import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.webengine.util.PathMatcher;

@XObject(value="path")
public class PathDescriptor
implements Comparable<PathDescriptor> {
    @XNode(value="@value")
    protected String value;
    @XNode(value="@regex")
    protected boolean regex = false;
    @XNode(value="@autoTx")
    protected Boolean autoTx;
    protected PathMatcher matcher;

    public PathMatcher getMatcher() {
        return this.matcher;
    }

    public String getValue() {
        return this.value;
    }

    public Boolean getAutoTx() {
        return this.autoTx;
    }

    public boolean isAutoTx(boolean defaultValue) {
        return this.autoTx == null ? defaultValue : this.autoTx;
    }

    public PathMatcher createMatcher() {
        if (this.value != null) {
            if (!this.value.startsWith("/")) {
                this.value = "/" + this.value;
            }
        } else {
            throw new IllegalArgumentException("Path value is required");
        }
        this.matcher = this.regex ? PathMatcher.getRegexMatcher(this.value) : PathMatcher.getPrefixMatcher(this.value);
        return this.matcher;
    }

    public boolean match(String path) {
        return this.matcher.match(path);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PathDescriptor) {
            PathDescriptor pd = (PathDescriptor)obj;
            return this.value != null && this.value.equals(pd.value) || this.value == pd.value;
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value + "; autoTx: " + this.autoTx;
    }

    @Override
    public int compareTo(PathDescriptor o) {
        int len2;
        if (this.regex != o.regex) {
            return this.regex ? 1 : -1;
        }
        int len1 = this.value.length();
        if (len1 == (len2 = o.value.length())) {
            return this.value.compareTo(o.value);
        }
        return len2 - len1;
    }
}

