/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app;

import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.core.MediaType;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.webengine.JsonFactoryManager;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.runtime.api.Framework;

public class JsonWebengineWriter {
    static JsonFactoryManager jsonFactoryManager;

    private static JsonFactory getFactory() {
        jsonFactoryManager = (JsonFactoryManager)Framework.getLocalService(JsonFactoryManager.class);
        return jsonFactoryManager.getJsonFactory();
    }

    private static JsonGenerator createGenerator(OutputStream out) throws IOException {
        return JsonWebengineWriter.getFactory().createJsonGenerator(out, JsonEncoding.UTF8);
    }

    public static void writeException(OutputStream out, WebException webException, MediaType mediaType) throws IOException {
        JsonWebengineWriter.writeException(JsonWebengineWriter.createGenerator(out), webException, mediaType);
    }

    public static void writeException(JsonGenerator jg, WebException webException, MediaType mediaType) throws IOException {
        jg.writeStartObject();
        jg.writeStringField("entity-type", "exception");
        jg.writeStringField("code", webException.getType());
        jg.writeNumberField("status", webException.getStatus());
        jg.writeStringField("message", webException.getMessage());
        if (jsonFactoryManager.isStackDisplay() || MediaType.valueOf((String)"application/json+nxentity").equals((Object)mediaType)) {
            jg.writeStringField("stacktrace", webException.getStackTraceString());
            jg.writeObjectField("exception", (Object)webException.getCause());
        }
        jg.writeEndObject();
        jg.flush();
    }
}

