/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.util;

import java.util.regex.Pattern;

public class PathMatcher {
    public static PathMatcher getRegexMatcher(String regex) {
        return new RegexMatcher(regex);
    }

    public static PathMatcher getPrefixMatcher(String prefix) {
        return new PrefixMatcher(prefix);
    }

    public static PathMatcher getAllMatcher() {
        return new PathMatcher();
    }

    protected PathMatcher() {
    }

    public boolean match(String value) {
        return true;
    }

    public static class PrefixMatcher
    extends PathMatcher {
        protected String prefix;

        public PrefixMatcher(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public boolean match(String value) {
            return value.startsWith(this.prefix);
        }
    }

    public static class RegexMatcher
    extends PathMatcher {
        protected Pattern pattern;

        public RegexMatcher(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public boolean match(String value) {
            return this.pattern.matcher(value).matches();
        }
    }
}

