/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.tag.Tag;
import org.nuxeo.ecm.platform.tag.TagService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class TagServiceImpl
extends DefaultComponent
implements TagService {
    public static final String NXTAG = "NXTAG";

    public boolean isEnabled() {
        return true;
    }

    protected static String cleanLabel(String label, boolean allowEmpty, boolean allowPercent) throws ClientException {
        if (label == null) {
            if (allowEmpty) {
                return null;
            }
            throw new ClientException("Invalid empty tag");
        }
        label = label.toLowerCase();
        label = label.replace(" ", "");
        label = label.replace("\\", "");
        label = label.replace("'", "");
        if (!allowPercent) {
            label = label.replace("%", "");
        }
        if (label.length() == 0) {
            throw new ClientException("Invalid empty tag");
        }
        return label;
    }

    protected static String cleanUsername(String username) {
        return username == null ? null : username.replace("'", "");
    }

    public void tag(CoreSession session, String docId, String label, String username) throws ClientException {
        UnrestrictedAddTagging r = new UnrestrictedAddTagging(session, docId, label, username);
        r.runUnrestricted();
        this.fireUpdateEvent(session, docId);
    }

    protected void fireUpdateEvent(CoreSession session, String docId) {
        IdRef documentRef = new IdRef(docId);
        if (session.exists((DocumentRef)documentRef)) {
            DocumentModel documentModel = session.getDocument((DocumentRef)documentRef);
            DocumentEventContext ctx = new DocumentEventContext(session, session.getPrincipal(), documentModel);
            Event event = ctx.newEvent("documentTagUpdated");
            ((EventService)Framework.getLocalService(EventService.class)).fireEvent(event);
        }
    }

    public void untag(CoreSession session, String docId, String label, String username) throws ClientException {
        UnrestrictedRemoveTagging r = new UnrestrictedRemoveTagging(session, docId, label, username);
        r.runUnrestricted();
        if (label != null) {
            this.fireUpdateEvent(session, docId);
        }
    }

    public List<Tag> getDocumentTags(CoreSession session, String docId, String username) throws ClientException {
        return this.getDocumentTags(session, docId, username, true);
    }

    public List<Tag> getDocumentTags(CoreSession session, String docId, String username, boolean useCore) throws ClientException {
        UnrestrictedGetDocumentTags r = new UnrestrictedGetDocumentTags(session, docId, username, useCore);
        r.runUnrestricted();
        return r.tags;
    }

    public void removeTags(CoreSession session, String docId) throws ClientException {
        this.untag(session, docId, null, null);
    }

    public void copyTags(CoreSession session, String srcDocId, String dstDocId) throws ClientException {
        this.copyTags(session, srcDocId, dstDocId, false);
    }

    protected void copyTags(CoreSession session, String srcDocId, String dstDocId, boolean removeExistingTags) throws ClientException {
        if (removeExistingTags) {
            this.removeTags(session, dstDocId);
        }
        UnrestrictedCopyTags r = new UnrestrictedCopyTags(session, srcDocId, dstDocId);
        r.runUnrestricted();
    }

    public void replaceTags(CoreSession session, String srcDocId, String dstDocId) throws ClientException {
        this.copyTags(session, srcDocId, dstDocId, true);
    }

    public List<String> getTagDocumentIds(CoreSession session, String label, String username) throws ClientException {
        UnrestrictedGetTagDocumentIds r = new UnrestrictedGetTagDocumentIds(session, label, username);
        r.runUnrestricted();
        return r.docIds;
    }

    public List<Tag> getTagCloud(CoreSession session, String docId, String username, Boolean normalize) throws ClientException {
        UnrestrictedGetDocumentCloud r = new UnrestrictedGetDocumentCloud(session, docId, username, normalize);
        r.runUnrestricted();
        return r.cloud;
    }

    public static void normalizeCloud(List<Tag> cloud, int min, int max, boolean linear) {
        double diff;
        double nmin;
        if (min == max) {
            for (Tag tag : cloud) {
                tag.setWeight(100L);
            }
            return;
        }
        if (linear) {
            nmin = min;
            diff = max - min;
        } else {
            nmin = Math.log(min);
            diff = Math.log(max) - nmin;
        }
        for (Tag tag : cloud) {
            long weight = tag.getWeight();
            double norm = linear ? ((double)weight - nmin) / diff : (Math.log(weight) - nmin) / diff;
            tag.setWeight(Math.round(100.0 * norm));
        }
    }

    public List<Tag> getSuggestions(CoreSession session, String label, String username) throws ClientException {
        UnrestrictedGetTagSuggestions r = new UnrestrictedGetTagSuggestions(session, label, username);
        r.runUnrestricted();
        return r.tags;
    }

    protected static List<Map<String, Serializable>> getItems(String pageProviderName, CoreSession session, Object ... params) {
        Map defProps;
        PageProviderService ppService = (PageProviderService)Framework.getService(PageProviderService.class);
        if (ppService == null) {
            throw new RuntimeException("Missing PageProvider service");
        }
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        PageProviderDefinition def = ppService.getPageProviderDefinition(pageProviderName);
        if (def != null && (defProps = def.getProperties()) != null) {
            props.putAll(defProps);
        }
        props.put("coreSession", (Serializable)session);
        PageProvider pp = ppService.getPageProvider(pageProviderName, null, null, null, props, params);
        if (pp == null) {
            throw new ClientException("Page provider not found: " + pageProviderName);
        }
        return pp.getCurrentPage();
    }

    protected static class UnrestrictedGetTagSuggestions
    extends UnrestrictedSessionRunner {
        protected final String label;
        protected final String username;
        protected final List<Tag> tags;

        protected UnrestrictedGetTagSuggestions(CoreSession session, String label, String username) throws ClientException {
            super(session);
            label = TagServiceImpl.cleanLabel(label, false, true);
            if (!label.contains("%")) {
                label = label + "%";
            }
            this.label = label;
            this.username = TagServiceImpl.cleanUsername(username);
            this.tags = new ArrayList<Tag>();
        }

        public void run() throws ClientException {
            List<Map<String, Serializable>> res = this.username == null ? TagServiceImpl.getItems(PAGE_PROVIDERS.GET_TAG_SUGGESTIONS.name(), this.session, this.label) : TagServiceImpl.getItems(PAGE_PROVIDERS.GET_TAG_SUGGESTIONS_FOR_USER.name(), this.session, this.label, this.username);
            if (res != null) {
                for (Map<String, Serializable> map : res) {
                    String label = (String)((Object)map.get("tag:label"));
                    this.tags.add(new Tag(label, 0));
                }
            }
            Collections.sort(this.tags, Tag.LABEL_COMPARATOR);
        }
    }

    protected static class UnrestrictedGetDocumentCloud
    extends UnrestrictedSessionRunner {
        protected final String docId;
        protected final String username;
        protected final List<Tag> cloud;
        protected final Boolean normalize;

        protected UnrestrictedGetDocumentCloud(CoreSession session, String docId, String username, Boolean normalize) throws ClientException {
            super(session);
            this.docId = docId;
            this.username = TagServiceImpl.cleanUsername(username);
            this.normalize = normalize;
            this.cloud = new ArrayList<Tag>();
        }

        public void run() throws ClientException {
            List<Map<String, Serializable>> res;
            if (this.docId == null) {
                res = this.username == null ? TagServiceImpl.getItems(PAGE_PROVIDERS.GET_ALL_TAGS.name(), this.session, new Object[0]) : TagServiceImpl.getItems(PAGE_PROVIDERS.GET_ALL_TAGS_FOR_USER.name(), this.session, this.username);
            } else {
                String path = this.session.getDocument((DocumentRef)new IdRef(this.docId)).getPathAsString();
                path = path.replace("'", "");
                ArrayList<String> docIds = new ArrayList<String>();
                docIds.add(this.docId);
                List<Map<String, Serializable>> docRes = TagServiceImpl.getItems(PAGE_PROVIDERS.GET_TAGGED_DOCUMENTS_UNDER.name(), this.session, path);
                if (docRes != null) {
                    for (Map<String, Serializable> map : docRes) {
                        docIds.add((String)((Object)map.get("ecm:uuid")));
                    }
                }
                res = this.username == null ? TagServiceImpl.getItems(PAGE_PROVIDERS.GET_TAGS_FOR_DOCUMENTS.name(), this.session, docIds) : TagServiceImpl.getItems(PAGE_PROVIDERS.GET_TAGS_FOR_DOCUMENTS_AND_USER.name(), this.session, docIds, this.username);
            }
            int min = 999999;
            int max = 0;
            if (res != null) {
                for (Map<String, Serializable> map : res) {
                    String label = (String)((Object)map.get("tag:label"));
                    int weight = ((Long)map.get("relation:source")).intValue();
                    if (weight == 0) continue;
                    if (weight > max) {
                        max = weight;
                    }
                    if (weight < min) {
                        min = weight;
                    }
                    Tag weightedTag = new Tag(label, weight);
                    this.cloud.add(weightedTag);
                }
            }
            if (this.normalize != null) {
                TagServiceImpl.normalizeCloud(this.cloud, min, max, this.normalize == false);
            }
        }
    }

    protected static class UnrestrictedGetTagDocumentIds
    extends UnrestrictedSessionRunner {
        protected final String label;
        protected final String username;
        protected final List<String> docIds;

        protected UnrestrictedGetTagDocumentIds(CoreSession session, String label, String username) throws ClientException {
            super(session);
            this.label = TagServiceImpl.cleanLabel(label, false, false);
            this.username = TagServiceImpl.cleanUsername(username);
            this.docIds = new ArrayList<String>();
        }

        public void run() throws ClientException {
            List<Map<String, Serializable>> res = this.username == null ? TagServiceImpl.getItems(PAGE_PROVIDERS.GET_DOCUMENTS_FOR_TAG.name(), this.session, this.label) : TagServiceImpl.getItems(PAGE_PROVIDERS.GET_DOCUMENTS_FOR_TAG_AND_USER.name(), this.session, this.label, this.username);
            if (res != null) {
                for (Map<String, Serializable> map : res) {
                    this.docIds.add((String)((Object)map.get("relation:source")));
                }
            }
        }
    }

    protected static class UnrestrictedCopyTags
    extends UnrestrictedSessionRunner {
        protected final String srcDocId;
        protected final String dstDocId;

        protected UnrestrictedCopyTags(CoreSession session, String srcDocId, String dstDocId) throws ClientException {
            super(session);
            this.srcDocId = srcDocId;
            this.dstDocId = dstDocId;
        }

        public void run() throws ClientException {
            List<Map<String, Serializable>> srcTagsRes;
            HashSet<String> existingTags = new HashSet<String>();
            List<Map<String, Serializable>> dstTagsRes = TagServiceImpl.getItems(PAGE_PROVIDERS.GET_TAGS_TO_COPY_FOR_DOCUMENT.name(), this.session, this.dstDocId);
            if (dstTagsRes != null) {
                for (Map<String, Serializable> map : dstTagsRes) {
                    existingTags.add(String.format("%s/%s", map.get("tag:label"), map.get("dc:creator")));
                }
            }
            if ((srcTagsRes = TagServiceImpl.getItems(PAGE_PROVIDERS.GET_TAGS_TO_COPY_FOR_DOCUMENT.name(), this.session, this.srcDocId)) != null) {
                boolean docCreated = false;
                for (Map<String, Serializable> map : srcTagsRes) {
                    String key = String.format("%s/%s", map.get("tag:label"), map.get("dc:creator"));
                    if (existingTags.contains(key)) continue;
                    DocumentModel tagging = this.session.createDocumentModel(null, (String)((Object)map.get("tag:label")), "Tagging");
                    tagging.setPropertyValue("dc:created", map.get("dc:created"));
                    tagging.setPropertyValue("dc:creator", map.get("dc:creator"));
                    tagging.setPropertyValue("relation:source", (Serializable)((Object)this.dstDocId));
                    tagging.setPropertyValue("relation:target", map.get("relation:target"));
                    this.session.createDocument(tagging);
                    docCreated = true;
                }
                if (docCreated) {
                    this.session.save();
                }
            }
        }
    }

    protected static class UnrestrictedGetDocumentTags
    extends UnrestrictedSessionRunner {
        protected final String docId;
        protected final String username;
        protected final List<Tag> tags;
        protected final boolean useCore;

        protected UnrestrictedGetDocumentTags(CoreSession session, String docId, String username, boolean useCore) throws ClientException {
            super(session);
            this.docId = docId;
            this.username = TagServiceImpl.cleanUsername(username);
            this.useCore = useCore;
            this.tags = new ArrayList<Tag>();
        }

        public void run() throws ClientException {
            List<Map<String, Serializable>> res;
            String ppName;
            if (this.username == null) {
                ppName = PAGE_PROVIDERS.GET_TAGS_FOR_DOCUMENT.name();
                if (this.useCore) {
                    ppName = PAGE_PROVIDERS.GET_TAGS_FOR_DOCUMENT_CORE.name();
                }
                res = TagServiceImpl.getItems(ppName, this.session, this.docId);
            } else {
                ppName = PAGE_PROVIDERS.GET_TAGS_FOR_DOCUMENT_AND_USER.name();
                if (this.useCore) {
                    ppName = PAGE_PROVIDERS.GET_TAGS_FOR_DOCUMENT_AND_USER_CORE.name();
                }
                res = TagServiceImpl.getItems(ppName, this.session, this.docId, this.username);
            }
            if (res != null) {
                for (Map<String, Serializable> map : res) {
                    String label = (String)((Object)map.get("tag:label"));
                    this.tags.add(new Tag(label, 0));
                }
            }
        }
    }

    protected static class UnrestrictedRemoveTagging
    extends UnrestrictedSessionRunner {
        private final String docId;
        private final String label;
        private final String username;

        protected UnrestrictedRemoveTagging(CoreSession session, String docId, String label, String username) throws ClientException {
            super(session);
            this.docId = docId;
            this.label = TagServiceImpl.cleanLabel(label, true, false);
            this.username = TagServiceImpl.cleanUsername(username);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws ClientException {
            String tagId = null;
            if (this.label != null) {
                List<Map<String, Serializable>> res = TagServiceImpl.getItems(PAGE_PROVIDERS.GET_DOCUMENT_IDS_FOR_TAG.name(), this.session, this.label);
                String string = tagId = res != null && !res.isEmpty() ? (String)((Object)res.get(0).get("ecm:uuid")) : null;
                if (tagId == null) {
                    return;
                }
            }
            HashSet<String> taggingIds = new HashSet<String>();
            String query = String.format("SELECT ecm:uuid FROM Tagging WHERE relation:source = '%s'", this.docId);
            if (tagId != null) {
                query = query + String.format(" AND relation:target = '%s'", tagId);
            }
            if (this.username != null) {
                query = query + String.format(" AND dc:creator = '%s'", this.username);
            }
            try (IterableQueryResult res = this.session.queryAndFetch(query, "NXQL", new Object[0]);){
                for (Map map : res) {
                    taggingIds.add((String)map.get("ecm:uuid"));
                }
            }
            for (String taggingId : taggingIds) {
                this.session.removeDocument((DocumentRef)new IdRef(taggingId));
            }
            if (!taggingIds.isEmpty()) {
                this.session.save();
            }
        }
    }

    protected static class UnrestrictedAddTagging
    extends UnrestrictedSessionRunner {
        private final String docId;
        private final String label;
        private final String username;

        protected UnrestrictedAddTagging(CoreSession session, String docId, String label, String username) throws ClientException {
            super(session);
            this.docId = docId;
            this.label = TagServiceImpl.cleanLabel(label, false, false);
            this.username = TagServiceImpl.cleanUsername(username);
        }

        public void run() throws ClientException {
            List<Map<String, Serializable>> res = TagServiceImpl.getItems(PAGE_PROVIDERS.GET_DOCUMENT_IDS_FOR_TAG.name(), this.session, this.label);
            String tagId = res != null && !res.isEmpty() ? (String)((Object)res.get(0).get("ecm:uuid")) : null;
            Calendar date = Calendar.getInstance();
            if (tagId == null) {
                DocumentModel tag = this.session.createDocumentModel(null, this.label, "Tag");
                tag.setPropertyValue("dc:created", (Serializable)date);
                tag.setPropertyValue("tag:label", (Serializable)((Object)this.label));
                tag = this.session.createDocument(tag);
                tagId = tag.getId();
            }
            if ((res = this.username != null ? TagServiceImpl.getItems(PAGE_PROVIDERS.GET_FIRST_TAGGING_FOR_DOC_AND_TAG_AND_USER.name(), this.session, this.docId, tagId, this.username) : TagServiceImpl.getItems(PAGE_PROVIDERS.GET_FIRST_TAGGING_FOR_DOC_AND_TAG.name(), this.session, this.docId, tagId)) != null && !res.isEmpty()) {
                return;
            }
            DocumentModel tagging = this.session.createDocumentModel(null, this.label, "Tagging");
            tagging.setPropertyValue("dc:created", (Serializable)date);
            if (this.username != null) {
                tagging.setPropertyValue("dc:creator", (Serializable)((Object)this.username));
            }
            tagging.setPropertyValue("relation:source", (Serializable)((Object)this.docId));
            tagging.setPropertyValue("relation:target", (Serializable)((Object)tagId));
            this.session.createDocument(tagging);
            this.session.save();
        }
    }

    protected static enum PAGE_PROVIDERS {
        GET_DOCUMENT_IDS_FOR_TAG,
        GET_FIRST_TAGGING_FOR_DOC_AND_TAG_AND_USER,
        GET_FIRST_TAGGING_FOR_DOC_AND_TAG,
        GET_TAGS_FOR_DOCUMENT,
        GET_TAGS_FOR_DOCUMENT_CORE,
        GET_DOCUMENTS_FOR_TAG,
        GET_TAGS_FOR_DOCUMENT_AND_USER,
        GET_TAGS_FOR_DOCUMENT_AND_USER_CORE,
        GET_DOCUMENTS_FOR_TAG_AND_USER,
        GET_TAGS_TO_COPY_FOR_DOCUMENT,
        GET_TAG_SUGGESTIONS,
        GET_TAG_SUGGESTIONS_FOR_USER,
        GET_TAGGED_DOCUMENTS_UNDER,
        GET_ALL_TAGS,
        GET_ALL_TAGS_FOR_USER,
        GET_TAGS_FOR_DOCUMENTS,
        GET_TAGS_FOR_DOCUMENTS_AND_USER;

    }
}

