/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.publisher;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocumentFactory;
import org.nuxeo.ecm.platform.publisher.api.PublisherException;
import org.nuxeo.ecm.platform.publisher.api.PublishingException;
import org.nuxeo.ecm.platform.publisher.impl.core.SimpleCorePublishedDocument;
import org.nuxeo.ecm.platform.publisher.task.CoreProxyWithWorkflowFactory;
import org.nuxeo.ecm.platform.rendition.Rendition;
import org.nuxeo.ecm.platform.rendition.RenditionException;
import org.nuxeo.ecm.platform.rendition.publisher.RenditionLiveDocFetcher;
import org.nuxeo.ecm.platform.rendition.publisher.RenditionsRemover;
import org.nuxeo.ecm.platform.rendition.service.RenditionService;
import org.nuxeo.runtime.api.Framework;

public class RenditionPublicationFactory
extends CoreProxyWithWorkflowFactory
implements PublishedDocumentFactory {
    public static final String RENDITION_NAME_PARAMETER_KEY = "renditionName";
    protected RenditionService renditionService;

    public PublishedDocument publishDocument(DocumentModel doc, PublicationNode targetNode, Map<String, String> params) throws ClientException {
        String renditionName;
        if (params != null && params.containsKey(RENDITION_NAME_PARAMETER_KEY) && !StringUtils.isEmpty((String)(renditionName = params.get(RENDITION_NAME_PARAMETER_KEY)))) {
            DocumentModel renditionDocument = null;
            Rendition rendition = null;
            try {
                rendition = this.getRenditionService().getRendition(doc, renditionName, true);
                if (rendition == null) {
                    throw new PublisherException("Unable to render the document");
                }
                renditionDocument = rendition.getHostDocument();
            }
            catch (RenditionException e) {
                throw new PublisherException(e.getLocalizedMessage(), (Throwable)e);
            }
            PublishedDocument publishedDocument = super.publishDocument(renditionDocument, targetNode, params);
            DocumentModel proxy = ((SimpleCorePublishedDocument)publishedDocument).getProxy();
            proxy.attach(doc.getSessionId());
            if (!this.hasValidationTask(publishedDocument)) {
                this.removeExistingProxiesOnPreviousVersions(proxy);
            }
            return publishedDocument;
        }
        return super.publishDocument(doc, targetNode, params);
    }

    protected DocumentModel getLiveDocument(CoreSession session, DocumentModel proxy) throws ClientException {
        if (!proxy.hasFacet("Rendition")) {
            return super.getLiveDocument(session, proxy);
        }
        RenditionLiveDocFetcher fetcher = new RenditionLiveDocFetcher(session, proxy);
        fetcher.runUnrestricted();
        return fetcher.getLiveDocument();
    }

    protected void removeExistingProxiesOnPreviousVersions(DocumentModel newProxy) throws PublishingException {
        if (!newProxy.hasFacet("Rendition")) {
            super.removeExistingProxiesOnPreviousVersions(newProxy);
            return;
        }
        RenditionsRemover remover = new RenditionsRemover(newProxy);
        try {
            remover.runUnrestricted();
        }
        catch (ClientException e) {
            throw new PublishingException("Unable to remove old puiblished renditions", (Throwable)e);
        }
    }

    protected RenditionService getRenditionService() throws ClientException {
        if (this.renditionService == null) {
            try {
                this.renditionService = (RenditionService)Framework.getService(RenditionService.class);
            }
            catch (Exception e) {
                String errMsg = "Error connecting to RenditionService. " + e.getMessage();
                throw new ClientException(errMsg, (Throwable)e);
            }
            if (this.renditionService == null) {
                throw new ClientException("RenditionService service not bound");
            }
        }
        return this.renditionService;
    }

    public static class RemoveACP
    extends UnrestrictedSessionRunner {
        protected DocumentRef docRef;

        public RemoveACP(CoreSession session, DocumentRef docRef) {
            super(session);
            this.docRef = docRef;
        }

        public void run() throws ClientException {
            ACPImpl acp = new ACPImpl();
            this.session.setACP(this.docRef, (ACP)acp, true);
        }
    }
}

