/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.tag.fn;

import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.cache.Cache;
import org.nuxeo.ecm.core.cache.CacheService;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.usermanager.UserConfig;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.event.Event;
import org.nuxeo.runtime.services.event.EventListener;
import org.nuxeo.runtime.services.event.EventService;

public class UserNameResolverHelper
implements EventListener {
    protected static final Log log = LogFactory.getLog(UserNameResolverHelper.class);
    public static final String USERNAMECACHE = "userDisplayName";
    protected volatile Cache cache;

    public String getUserFullName(String login) {
        String displayName = null;
        Cache cache = this.getCache();
        if (cache != null) {
            try {
                displayName = (String)((Object)cache.get(login));
            }
            catch (IOException e) {
                log.error((Object)("Unable to access cache userDisplayName for entry " + login), (Throwable)e);
            }
        }
        if (displayName == null) {
            displayName = this.computeUserFullName(login);
            if (cache != null) {
                try {
                    cache.put(login, (Serializable)((Object)displayName));
                }
                catch (IOException e) {
                    log.error((Object)("Unable to access cache userDisplayName for entry " + login), (Throwable)e);
                }
            }
        }
        if (displayName == null) {
            displayName = login;
        }
        return displayName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Cache getCache() {
        Cache result = this.cache;
        if (result == null) {
            UserNameResolverHelper userNameResolverHelper = this;
            synchronized (userNameResolverHelper) {
                CacheService cs;
                result = this.cache;
                if (result == null && (cs = (CacheService)Framework.getService(CacheService.class)) != null) {
                    result = cs.getCache(USERNAMECACHE);
                    if (result != null) {
                        EventService es = (EventService)Framework.getService(EventService.class);
                        es.addListener("usermanager", (EventListener)this);
                    }
                    this.cache = result;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String computeUserFullName(String login) {
        UserManager um = (UserManager)Framework.getService(UserManager.class);
        String dname = um.getUserDirectoryName();
        try (Session dirSession = ((DirectoryService)Framework.getService(DirectoryService.class)).open(dname);){
            DocumentModel entry = dirSession.getEntry(login, false);
            if (entry == null) {
                NuxeoPrincipal principal = um.getPrincipal(login);
                if (principal != null) {
                    String string = this.computeUserFullName(principal);
                    return string;
                }
                String string = login;
                return string;
            }
            DataModel model = entry.getDataModel(um.getUserSchemaName());
            String string = this.computeUserFullName(model);
            return string;
        }
    }

    protected String computeUserFullName(DataModel model) {
        String first = (String)model.getData(UserConfig.DEFAULT.firstNameKey);
        String last = (String)model.getData(UserConfig.DEFAULT.lastNameKey);
        String username = (String)model.getData(UserConfig.DEFAULT.nameKey);
        return this.userDisplayName(username, first, last);
    }

    protected String computeUserFullName(NuxeoPrincipal principal) {
        String first = principal.getFirstName();
        String last = principal.getLastName();
        return this.userDisplayName(principal.getName(), first, last);
    }

    protected String userDisplayName(String id, String first, String last) {
        if (first == null || first.length() == 0) {
            if (last == null || last.length() == 0) {
                return id;
            }
            return last;
        }
        if (last == null || last.length() == 0) {
            return first;
        }
        return first + ' ' + last;
    }

    public boolean aboutToHandleEvent(Event arg0) {
        return true;
    }

    public void handleEvent(Event event) {
        if ("user_changed".equals(event.getId())) {
            String userName = (String)event.getData();
            Cache cache = this.getCache();
            if (cache != null) {
                try {
                    cache.invalidate(userName);
                }
                catch (IOException e) {
                    log.error((Object)"Unable to invalidate entry", (Throwable)e);
                }
            }
        }
    }
}

