/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.contentview.jsf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewDescriptor;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewLayout;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewLayoutImpl;
import org.nuxeo.ecm.platform.query.core.CoreQueryPageProviderDescriptor;
import org.nuxeo.ecm.platform.query.core.GenericPageProviderDescriptor;
import org.nuxeo.ecm.platform.query.core.ReferencePageProviderDescriptor;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class ContentViewRegistry
extends ContributionFragmentRegistry<ContentViewDescriptor> {
    protected static final Log log = LogFactory.getLog(ContentViewRegistry.class);
    protected final Map<String, ContentViewDescriptor> contentViews = new HashMap<String, ContentViewDescriptor>();
    protected final Map<String, Set<String>> contentViewsByFlag = new HashMap<String, Set<String>>();

    public String getContributionId(ContentViewDescriptor contrib) {
        return contrib.getName();
    }

    public void contributionUpdated(String id, ContentViewDescriptor contrib, ContentViewDescriptor newOrigContrib) {
        String name = contrib.getName();
        if (name == null) {
            log.error((Object)"Cannot register content view without a name");
            return;
        }
        if (this.contentViews.containsKey(id)) {
            this.contentViews.remove(id);
            this.removeContentViewFlags(name);
        }
        if (contrib.isEnabled()) {
            this.contentViews.put(name, contrib);
            this.addContentViewFlags(contrib);
            log.info((Object)("Registering content view with name " + id));
        }
    }

    public void contributionRemoved(String id, ContentViewDescriptor origContrib) {
        this.contentViews.remove(id);
        this.removeContentViewFlags(origContrib);
        log.info((Object)("Unregistering content view with name " + id));
    }

    protected void addContentViewFlags(ContentViewDescriptor desc) {
        String name = desc.getName();
        List<String> flags = desc.getFlags();
        if (flags != null) {
            for (String flag : flags) {
                Set<String> items = this.contentViewsByFlag.get(flag);
                if (items == null) {
                    items = new LinkedHashSet<String>();
                }
                items.add(name);
                this.contentViewsByFlag.put(flag, items);
            }
        }
    }

    protected void removeContentViewFlags(String contentViewName) {
        for (Set<String> items : this.contentViewsByFlag.values()) {
            if (items == null) continue;
            items.remove(contentViewName);
        }
    }

    protected void removeContentViewFlags(ContentViewDescriptor desc) {
        String name = desc.getName();
        List<String> flags = desc.getFlags();
        if (flags != null) {
            for (String flag : flags) {
                Set<String> items = this.contentViewsByFlag.get(flag);
                if (items == null) continue;
                items.remove(name);
            }
        }
    }

    public ContentViewDescriptor clone(ContentViewDescriptor orig) {
        return orig.clone();
    }

    public void merge(ContentViewDescriptor newDesc, ContentViewDescriptor oldDesc) {
        String resultLayout;
        String resultCols;
        String searchDocument;
        Boolean showFilterForm;
        Boolean showRefreshCommand;
        Boolean showPageSizeSelector;
        Boolean showTitle;
        Boolean useGlobalPageSize;
        String selectionList;
        List<String> flags;
        List<ContentViewLayout> resultLayouts;
        ContentViewLayoutImpl searchLayout;
        List<String> events;
        String pagination;
        ReferencePageProviderDescriptor refDesc;
        GenericPageProviderDescriptor genDesc;
        CoreQueryPageProviderDescriptor coreDesc;
        Integer cacheSize;
        String cacheKey;
        List<String> actions;
        String iconPath;
        Boolean translateEmptySentence;
        String emptySentence;
        Boolean translateTitle;
        oldDesc.setEnabled(newDesc.isEnabled());
        String title = newDesc.getTitle();
        if (title != null) {
            oldDesc.title = title;
        }
        if ((translateTitle = newDesc.getTranslateTitle()) != null) {
            oldDesc.translateTitle = translateTitle;
        }
        if ((emptySentence = newDesc.getEmptySentence()) != null) {
            oldDesc.emptySentence = emptySentence;
        }
        if ((translateEmptySentence = newDesc.getTranslateEmptySentence()) != null) {
            oldDesc.translateEmptySentence = translateEmptySentence;
        }
        if ((iconPath = newDesc.getIconPath()) != null) {
            oldDesc.iconPath = iconPath;
        }
        if ((actions = newDesc.getActionCategories()) != null && !actions.isEmpty()) {
            oldDesc.actionCategories = actions;
        }
        if ((cacheKey = newDesc.getCacheKey()) != null) {
            oldDesc.cacheKey = cacheKey;
        }
        if ((cacheSize = newDesc.getCacheSize()) != null) {
            oldDesc.cacheSize = cacheSize;
        }
        if ((coreDesc = newDesc.getCoreQueryPageProvider()) != null && coreDesc.isEnabled()) {
            oldDesc.coreQueryPageProvider = coreDesc;
            oldDesc.genericPageProvider = null;
            oldDesc.referencePageProvider = null;
        }
        if ((genDesc = newDesc.getGenericPageProvider()) != null && genDesc.isEnabled()) {
            oldDesc.genericPageProvider = genDesc;
            oldDesc.coreQueryPageProvider = null;
            oldDesc.referencePageProvider = null;
        }
        if ((refDesc = newDesc.getReferencePageProvider()) != null && refDesc.isEnabled()) {
            oldDesc.referencePageProvider = refDesc;
            oldDesc.coreQueryPageProvider = null;
            oldDesc.genericPageProvider = null;
        }
        if ((pagination = newDesc.getPagination()) != null) {
            oldDesc.pagination = pagination;
        }
        if ((events = newDesc.getRefreshEventNames()) != null && !events.isEmpty()) {
            oldDesc.refreshEventNames = events;
        }
        if ((events = newDesc.getResetEventNames()) != null && !events.isEmpty()) {
            oldDesc.resetEventNames = events;
        }
        if ((searchLayout = newDesc.getSearchLayout()) != null) {
            oldDesc.searchLayout = searchLayout;
        }
        if ((resultLayouts = newDesc.getResultLayouts()) != null) {
            Boolean appendResultLayout = newDesc.getAppendResultLayouts();
            if (Boolean.TRUE.equals(appendResultLayout) || resultLayouts.isEmpty()) {
                ArrayList<ContentViewLayout> allLayouts = new ArrayList<ContentViewLayout>();
                if (oldDesc.resultLayouts != null) {
                    allLayouts.addAll(oldDesc.resultLayouts);
                }
                allLayouts.addAll(resultLayouts);
                oldDesc.resultLayouts = allLayouts;
            } else {
                oldDesc.resultLayouts = resultLayouts;
            }
        }
        if ((flags = newDesc.getFlags()) != null && !flags.isEmpty()) {
            oldDesc.flags = flags;
        }
        if ((selectionList = newDesc.getSelectionListName()) != null) {
            oldDesc.selectionList = selectionList;
        }
        if ((useGlobalPageSize = newDesc.getUseGlobalPageSize()) != null) {
            oldDesc.useGlobalPageSize = useGlobalPageSize;
        }
        if ((showTitle = newDesc.getShowTitle()) != null) {
            oldDesc.showTitle = showTitle;
        }
        if ((showPageSizeSelector = newDesc.showPageSizeSelector) != null) {
            oldDesc.showPageSizeSelector = showPageSizeSelector;
        }
        if ((showRefreshCommand = newDesc.showRefreshCommand) != null) {
            oldDesc.showRefreshCommand = showRefreshCommand;
        }
        if ((showFilterForm = newDesc.getShowFilterForm()) != null) {
            oldDesc.showFilterForm = showFilterForm;
        }
        if ((searchDocument = newDesc.getSearchDocumentBinding()) != null) {
            oldDesc.searchDocument = searchDocument;
        }
        if ((resultCols = newDesc.getResultColumnsBinding()) != null) {
            oldDesc.resultColumns = resultCols;
        }
        if ((resultLayout = newDesc.getResultLayoutBinding()) != null) {
            oldDesc.resultLayout = resultLayout;
        }
    }

    public ContentViewDescriptor getContentView(String id) {
        return this.contentViews.get(id);
    }

    public boolean hasContentView(String id) {
        return this.contentViews.containsKey(id);
    }

    public Set<String> getContentViewsByFlag(String flag) {
        return this.contentViewsByFlag.get(flag);
    }

    public Set<String> getContentViewNames() {
        return this.contentViews.keySet();
    }

    public Collection<ContentViewDescriptor> getContentViews() {
        return this.contentViews.values();
    }
}

