/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.aggregate;

import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.query.api.AggregateDefinition;
import org.nuxeo.ecm.platform.query.api.Bucket;
import org.nuxeo.elasticsearch.aggregate.AggregateEsBase;
import org.nuxeo.elasticsearch.aggregate.DateHistogramAggregate;
import org.nuxeo.elasticsearch.aggregate.DateRangeAggregate;
import org.nuxeo.elasticsearch.aggregate.HistogramAggregate;
import org.nuxeo.elasticsearch.aggregate.RangeAggregate;
import org.nuxeo.elasticsearch.aggregate.SignificantTermAggregate;
import org.nuxeo.elasticsearch.aggregate.TermAggregate;

public final class AggregateFactory {
    private AggregateFactory() {
    }

    public static AggregateEsBase<? extends Bucket> create(AggregateDefinition def, DocumentModel searchDocumentModel) {
        switch (def.getType()) {
            case "terms": {
                return new TermAggregate(def, searchDocumentModel);
            }
            case "range": {
                return new RangeAggregate(def, searchDocumentModel);
            }
            case "date_histogram": {
                return new DateHistogramAggregate(def, searchDocumentModel);
            }
            case "significant_terms": {
                return new SignificantTermAggregate(def, searchDocumentModel);
            }
            case "histogram": {
                return new HistogramAggregate(def, searchDocumentModel);
            }
            case "date_range": {
                return new DateRangeAggregate(def, searchDocumentModel);
            }
        }
        throw new IllegalArgumentException("Unknown aggregate type: " + def.getType());
    }
}

