/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.work;

import java.util.List;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.commands.IndexingCommand;
import org.nuxeo.elasticsearch.core.IndexingMonitor;
import org.nuxeo.elasticsearch.work.AbstractIndexingWorker;
import org.nuxeo.elasticsearch.work.ChildrenIndexingWorker;
import org.nuxeo.runtime.api.Framework;

public class IndexingWorker
extends AbstractIndexingWorker
implements Work {
    private static final long serialVersionUID = -5141471452954319812L;

    public IndexingWorker(IndexingMonitor monitor, String repositoryName, List<IndexingCommand> cmds) {
        super(monitor, repositoryName, cmds);
    }

    public String getTitle() {
        return " ElasticSearch indexing for docs: " + this.getCmdsDigest();
    }

    protected boolean needRecurse(IndexingCommand cmd) {
        if (cmd.isRecurse()) {
            switch (cmd.getType()) {
                case INSERT: 
                case UPDATE: 
                case UPDATE_SECURITY: {
                    return true;
                }
                case DELETE: {
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    protected void doIndexingWork(ElasticSearchIndexing esi, List<IndexingCommand> cmds) {
        esi.indexNonRecursive(cmds);
        WorkManager wm = (WorkManager)Framework.getLocalService(WorkManager.class);
        for (IndexingCommand cmd : cmds) {
            if (!this.needRecurse(cmd)) continue;
            ChildrenIndexingWorker subWorker = new ChildrenIndexingWorker(this.monitor, cmd);
            wm.schedule((Work)subWorker);
        }
    }

    public String getCmdsDigest() {
        String ret = "";
        for (IndexingCommand cmd : this.cmds) {
            ret = ret + " " + cmd.getId();
        }
        return ret;
    }
}

