/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.work;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.elasticsearch.core.IndexingMonitor;
import org.nuxeo.elasticsearch.work.BaseIndexingWorker;
import org.nuxeo.elasticsearch.work.BucketIndexingWorker;
import org.nuxeo.runtime.api.Framework;

public class ScrollingIndexingWorker
extends BaseIndexingWorker
implements Work {
    private static final Log log = LogFactory.getLog(ScrollingIndexingWorker.class);
    private static final long serialVersionUID = -4507677669419340384L;
    private static final String DEFAULT_BUCKET_SIZE = "500";
    protected final String nxql;
    protected transient WorkManager workManager;
    protected long documentCount = 0L;

    public ScrollingIndexingWorker(IndexingMonitor monitor, String repositoryName, String nxql) {
        super(monitor);
        this.repositoryName = repositoryName;
        this.nxql = nxql;
    }

    public String getTitle() {
        return "Elasticsearch scrolling indexer: " + this.nxql + ", processed " + this.documentCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doWork() throws Exception {
        String jobName = this.getSchedulePath().getPath();
        log.warn((Object)String.format("Re-indexing job: %s started, NXQL: %s on repository: %s", jobName, this.nxql, this.repositoryName));
        CoreSession session = this.initSession(this.repositoryName);
        IterableQueryResult res = session.queryAndFetch(this.nxql, "NXQL", new Object[0]);
        int bucketCount = 0;
        try {
            Iterator it = res.iterator();
            int bucketSize = this.getBucketSize();
            ArrayList<String> ids = new ArrayList<String>(bucketSize);
            while (it.hasNext()) {
                ++this.documentCount;
                ids.add((String)((Map)it.next()).get("ecm:uuid"));
                if (ids.size() != bucketSize) continue;
                this.scheduleBucketWorker(ids, false);
                ids = new ArrayList(bucketSize);
                ++bucketCount;
            }
            this.scheduleBucketWorker(ids, true);
            if (!ids.isEmpty()) {
                ++bucketCount;
            }
        }
        catch (Throwable throwable) {
            res.close();
            log.warn((Object)String.format("Re-indexing job: %s has submited %d documents in %d bucket workers", jobName, this.documentCount, bucketCount));
            throw throwable;
        }
        res.close();
        log.warn((Object)String.format("Re-indexing job: %s has submited %d documents in %d bucket workers", jobName, this.documentCount, bucketCount));
    }

    protected void scheduleBucketWorker(List<String> bucket, boolean isLast) {
        if (bucket.isEmpty()) {
            return;
        }
        BucketIndexingWorker subWorker = new BucketIndexingWorker(this.monitor, this.repositoryName, bucket, isLast);
        this.getWorkManager().schedule((Work)subWorker);
    }

    protected WorkManager getWorkManager() {
        if (this.workManager == null) {
            this.workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
        }
        return this.workManager;
    }

    protected int getBucketSize() {
        String value = Framework.getProperty((String)"elasticsearch.reindex.bucketReadSize", (String)DEFAULT_BUCKET_SIZE);
        return Integer.parseInt(value);
    }
}

