/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.contentbrowser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.nuxeo.ecm.webapp.contentbrowser.ServerActions;
import org.nuxeo.runtime.api.Framework;

@Name(value="serverActions")
@Scope(value=ScopeType.CONVERSATION)
public class ServerActionsBean
implements ServerActions,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String DEFAULT_VIEW = "view_domains";
    private static final Log log = LogFactory.getLog(ServerActionsBean.class);
    @In(required=true, create=true)
    protected transient NavigationContext navigationContext;

    @Override
    @Factory(value="availableCoreRepositories")
    public List<Repository> getAvailableRepositories() throws ClientException {
        try {
            RepositoryManager repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
            return new ArrayList<Repository>(repositoryManager.getRepositories());
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    @Override
    public String selectRepository(String repositoryName) throws ClientException {
        try {
            boolean found = false;
            RepositoryManager repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
            for (String name : repositoryManager.getRepositoryNames()) {
                if (!name.equals(repositoryName)) continue;
                found = true;
                break;
            }
            if (found) {
                log.debug((Object)("Selected core name: " + repositoryName));
                RepositoryLocation selectedLocation = new RepositoryLocation(repositoryName);
                this.navigationContext.setCurrentServerLocation(selectedLocation);
                return DEFAULT_VIEW;
            }
            return null;
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }
}

