/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.statuses;

import java.util.Calendar;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.nuxeo.ecm.core.management.CoreManagementService;
import org.nuxeo.ecm.core.management.api.AdministrativeStatus;
import org.nuxeo.ecm.core.management.api.AdministrativeStatusManager;
import org.nuxeo.ecm.core.management.api.GlobalAdministrativeStatusManager;
import org.nuxeo.ecm.core.management.statuses.AdministrableServiceDescriptor;
import org.nuxeo.ecm.core.management.statuses.CoreEventNotifier;
import org.nuxeo.ecm.core.management.statuses.Notifier;
import org.nuxeo.ecm.core.management.statuses.NuxeoInstanceIdentifierHelper;
import org.nuxeo.ecm.core.management.statuses.RuntimeEventNotifier;
import org.nuxeo.ecm.core.management.storage.AdministrativeStatusPersister;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class AdministrativeStatusManagerImpl
implements AdministrativeStatusManager,
CoreManagementService {
    protected final AdministrativeStatusPersister persister;
    protected final GlobalAdministrativeStatusManager globalManager;
    protected final String serverInstanceName;
    protected final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "Nuxeo-Administrative-Statuses-Notify-Scheduler");
        }
    });
    protected final Notifier[] notifiers = new Notifier[]{new CoreEventNotifier(), new RuntimeEventNotifier()};

    public AdministrativeStatusManagerImpl(GlobalAdministrativeStatusManager globalManager, AdministrativeStatusPersister persister) {
        this.globalManager = globalManager;
        this.persister = persister;
        this.serverInstanceName = NuxeoInstanceIdentifierHelper.getServerInstanceName();
    }

    public AdministrativeStatusManagerImpl(GlobalAdministrativeStatusManager globalManager, AdministrativeStatusPersister persister, String instanceIdentifier) {
        this.globalManager = globalManager;
        this.persister = persister;
        this.serverInstanceName = instanceIdentifier;
    }

    protected String getServerInstanceName() {
        return this.serverInstanceName;
    }

    protected void notifyEvent(String eventName, String instanceIdentifier, String serviceIdentifier) {
        for (Notifier notifier : this.notifiers) {
            notifier.notifyEvent(eventName, instanceIdentifier, serviceIdentifier);
        }
    }

    public void onNuxeoServerStartup() {
        List<AdministrativeStatus> savedStatuses = this.persister.getAllStatuses(this.serverInstanceName);
        List<AdministrableServiceDescriptor> descs = this.globalManager.listRegistredServices();
        for (AdministrableServiceDescriptor desc : descs) {
            boolean serviceExist = false;
            for (AdministrativeStatus status : savedStatuses) {
                if (!desc.getId().equals(status.getServiceIdentifier())) continue;
                serviceExist = true;
                break;
            }
            if (serviceExist) continue;
            AdministrativeStatus newStatus = new AdministrativeStatus(desc.getInitialState(), "", Calendar.getInstance(), "system", this.serverInstanceName, desc.getId());
            this.persister.saveStatus(newStatus);
        }
        this.doNotifyAllStatuses();
        this.scheduler.scheduleAtFixedRate(new NotifyStatusesHandler(), 5L, 5L, TimeUnit.MINUTES);
    }

    protected void doNotifyAllStatuses() {
        for (AdministrativeStatus status : this.persister.getAllStatuses(this.serverInstanceName)) {
            this.notifyOnStatus(status);
        }
    }

    public void onNuxeoServerShutdown() {
        this.scheduler.shutdown();
    }

    protected void notifyOnStatus(AdministrativeStatus status) {
        if (status.isActive()) {
            this.notifyEvent("serviceActivated", status.getInstanceIdentifier(), status.getServiceIdentifier());
        } else if (status.isPassive()) {
            this.notifyEvent("servicePassivated", status.getInstanceIdentifier(), status.getServiceIdentifier());
        }
    }

    @Override
    public AdministrativeStatus activateNuxeoInstance(String message, String login) {
        return this.activate("org.nuxeo.ecm.instance.availability", message, login);
    }

    @Override
    public AdministrativeStatus deactivateNuxeoInstance(String message, String login) {
        return this.deactivate("org.nuxeo.ecm.instance.availability", message, login);
    }

    @Override
    public AdministrativeStatus getNuxeoInstanceStatus() {
        return this.getStatus("org.nuxeo.ecm.instance.availability");
    }

    @Override
    public AdministrativeStatus setNuxeoInstanceStatus(String state, String message, String login) {
        return this.setStatus("org.nuxeo.ecm.instance.availability", state, message, login);
    }

    @Override
    public AdministrativeStatus activate(String serviceIdentifier, String message, String login) {
        return this.setStatus(serviceIdentifier, "active", message, login);
    }

    @Override
    public AdministrativeStatus deactivate(String serviceIdentifier, String message, String login) {
        return this.setStatus(serviceIdentifier, "passive", message, login);
    }

    @Override
    public AdministrativeStatus setStatus(String serviceIdentifier, String state, String message, String login) {
        AdministrativeStatus status = new AdministrativeStatus(state, message, Calendar.getInstance(), login, this.serverInstanceName, serviceIdentifier);
        status = this.persister.saveStatus(status);
        this.notifyOnStatus(status);
        return this.addLabelAndDescription(status);
    }

    @Override
    public List<AdministrativeStatus> getAllStatuses() {
        List<AdministrativeStatus> statuses = this.persister.getAllStatuses(this.serverInstanceName);
        for (AdministrativeStatus status : statuses) {
            this.addLabelAndDescription(status);
        }
        return statuses;
    }

    protected AdministrativeStatus addLabelAndDescription(AdministrativeStatus status) {
        if (status == null) {
            return null;
        }
        String id = status.getServiceIdentifier();
        AdministrableServiceDescriptor desc = this.globalManager.getServiceDescriptor(id);
        if (desc != null) {
            status.setLabelAndDescription(desc.getLabel(), desc.getDescription());
        }
        return status;
    }

    @Override
    public AdministrativeStatus getStatus(String serviceIdentifier) {
        AdministrativeStatus status = this.persister.getStatus(this.serverInstanceName, serviceIdentifier);
        this.addLabelAndDescription(status);
        return status;
    }

    public class NotifyStatusesHandler
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TransactionHelper.startTransaction();
            boolean notified = false;
            try {
                AdministrativeStatusManagerImpl.this.doNotifyAllStatuses();
                notified = true;
            }
            finally {
                if (!notified) {
                    TransactionHelper.setTransactionRollbackOnly();
                }
                TransactionHelper.commitOrRollbackTransaction();
            }
        }
    }
}

