/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import org.codehaus.groovy.tools.shell.util.ANSI;
import org.codehaus.groovy.tools.shell.util.Preferences;

public class IO {
    public final InputStream inputStream;
    public final OutputStream outputStream;
    public final OutputStream errorStream;
    public final Reader in;
    public final PrintWriter out;
    public final PrintWriter err;
    static final /* synthetic */ boolean $assertionsDisabled;

    public IO(InputStream inputStream, OutputStream outputStream, OutputStream errorStream) {
        if (!$assertionsDisabled && inputStream == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && outputStream == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && errorStream == null) {
            throw new AssertionError();
        }
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.errorStream = errorStream;
        this.in = new InputStreamReader(inputStream);
        this.out = new ANSI.RenderWriter(outputStream, true);
        this.err = new ANSI.RenderWriter(errorStream, true);
    }

    public IO() {
        this(System.in, System.out, System.err);
    }

    public void setVerbosity(Verbosity verbosity) {
        if (!$assertionsDisabled && verbosity == null) {
            throw new AssertionError();
        }
        Preferences.verbosity = verbosity;
    }

    public Verbosity getVerbosity() {
        return Preferences.verbosity;
    }

    public boolean isQuiet() {
        return this.getVerbosity() == Verbosity.QUIET;
    }

    public boolean isInfo() {
        return this.getVerbosity() == Verbosity.INFO;
    }

    public boolean isVerbose() {
        return this.getVerbosity() == Verbosity.VERBOSE;
    }

    public boolean isDebug() {
        return this.getVerbosity() == Verbosity.DEBUG;
    }

    public void flush() throws IOException {
        this.out.flush();
        this.err.flush();
    }

    public void close() throws IOException {
        this.in.close();
        this.out.close();
        this.err.close();
    }

    static {
        $assertionsDisabled = !IO.class.desiredAssertionStatus();
    }

    public static final class Verbosity {
        public static final Verbosity QUIET;
        public static final Verbosity INFO;
        public static final Verbosity VERBOSE;
        public static final Verbosity DEBUG;
        public final String name;
        static final /* synthetic */ boolean $assertionsDisabled;

        private Verbosity(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Verbosity forName(String name) {
            if (!$assertionsDisabled && name == null) {
                throw new AssertionError();
            }
            if (Verbosity.QUIET.name.equalsIgnoreCase(name)) {
                return QUIET;
            }
            if (Verbosity.INFO.name.equalsIgnoreCase(name)) {
                return INFO;
            }
            if (Verbosity.VERBOSE.name.equalsIgnoreCase(name)) {
                return VERBOSE;
            }
            if (Verbosity.DEBUG.name.equalsIgnoreCase(name)) {
                return DEBUG;
            }
            throw new IllegalArgumentException("Invalid verbosity name: " + name);
        }

        static {
            $assertionsDisabled = !(class$org$codehaus$groovy$tools$shell$IO == null ? (class$org$codehaus$groovy$tools$shell$IO = IO.class$("org.codehaus.groovy.tools.shell.IO")) : class$org$codehaus$groovy$tools$shell$IO).desiredAssertionStatus();
            QUIET = new Verbosity("QUIET");
            INFO = new Verbosity("INFO");
            VERBOSE = new Verbosity("VERBOSE");
            DEBUG = new Verbosity("DEBUG");
        }
    }
}

